/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImportPluginFilter
implements PluginFilter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Set<String> enablePluginIds;

    public ImportPluginFilter(List<String> pluginIds) {
        Objects.requireNonNull(pluginIds, "pluginIds");
        this.enablePluginIds = new HashSet<String>(pluginIds);
    }

    @Override
    public boolean accept(PluginJar pluginJar) {
        String pluginId = pluginJar.getPluginId();
        if (this.enablePluginIds.contains(pluginId)) {
            this.logger.info("Enable plugin : {}", (Object)pluginId);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EnablePluginFilter{");
        sb.append("enablePluginIds=").append(this.enablePluginIds);
        sb.append('}');
        return sb.toString();
    }
}

