/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.profiler.instrument.GuardInstrumentor;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import com.navercorp.pinpoint.profiler.plugin.TransformCallbackProvider;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Objects;

public class MatchableClassFileTransformerDelegate
implements MatchableClassFileTransformer {
    private final ProfilerConfig profilerConfig;
    private final InstrumentContext instrumentContext;
    private final Matcher matcher;
    private final TransformCallbackProvider transformCallbackProvider;

    public MatchableClassFileTransformerDelegate(ProfilerConfig profilerConfig, InstrumentContext instrumentContext, Matcher matcher, TransformCallbackProvider transformCallbackProvider) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.instrumentContext = Objects.requireNonNull(instrumentContext, "instrumentContext");
        this.matcher = Objects.requireNonNull(matcher, "matcher");
        this.transformCallbackProvider = Objects.requireNonNull(transformCallbackProvider, "transformCallback");
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Objects.requireNonNull(className, "className");
        InstrumentContext instrumentContext = this.instrumentContext;
        try (GuardInstrumentor guard = new GuardInstrumentor(this.profilerConfig, instrumentContext);){
            TransformCallback transformCallback = this.transformCallbackProvider.getTransformCallback(instrumentContext, loader);
            byte[] byArray = transformCallback.doInTransform((Instrumentor)guard, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            return byArray;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MatchableClassFileTransformerDelegate{");
        sb.append("matcher=").append(this.matcher);
        sb.append(", transformCallbackProvider=").append(this.transformCallbackProvider);
        sb.append('}');
        return sb.toString();
    }
}

