/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.ClassFilter;
import com.navercorp.pinpoint.bootstrap.instrument.ClassInputStreamProvider;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetConstructor;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetConstructors;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetFilter;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetMethod;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.TargetMethods;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.plugin.ObjectFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.ASMAspectWeaver;
import com.navercorp.pinpoint.profiler.instrument.ASMClassNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMFieldNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMMethod;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMNestedClass;
import com.navercorp.pinpoint.profiler.instrument.AccessorAnalyzer;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.GetterAnalyzer;
import com.navercorp.pinpoint.profiler.instrument.SetterAnalyzer;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.AutoBindingObjectFactory;
import com.navercorp.pinpoint.profiler.objectfactory.InterceptorArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class ASMClass
implements InstrumentClass {
    private static final String FIELD_PREFIX = "_$PINPOINT$_";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final EngineComponent engineComponent;
    private final InstrumentContext pluginContext;
    private final ASMClassNodeAdapter classNode;
    private boolean modified = false;
    private String name;

    public ASMClass(EngineComponent engineComponent, InstrumentContext pluginContext, ClassLoader classLoader, ProtectionDomain protectionDomain, ClassNode classNode) {
        this(engineComponent, pluginContext, new ASMClassNodeAdapter((ClassInputStreamProvider)pluginContext, classLoader, protectionDomain, classNode));
    }

    public ASMClass(EngineComponent engineComponent, InstrumentContext pluginContext, ASMClassNodeAdapter classNode) {
        this.engineComponent = Objects.requireNonNull(engineComponent, "engineComponent");
        this.pluginContext = pluginContext;
        this.classNode = Objects.requireNonNull(classNode, "classNode");
    }

    public void test() {
    }

    public ClassLoader getClassLoader() {
        return this.classNode.getClassLoader();
    }

    public boolean isInterceptable() {
        if (this.isAnnotation() || this.isModified()) {
            return false;
        }
        return !this.isInterface() || this.classNode.getMajorVersion() >= 52 && JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_8);
    }

    public boolean isInterface() {
        return this.classNode.isInterface();
    }

    private boolean isAnnotation() {
        return this.classNode.isAnnotation();
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.classNode.getName();
        }
        return this.name;
    }

    public String getSuperClass() {
        return this.classNode.getSuperClassName();
    }

    public String[] getInterfaces() {
        return this.classNode.getInterfaceNames();
    }

    public InstrumentMethod getDeclaredMethod(String methodName, String ... parameterTypes) {
        Objects.requireNonNull(methodName, "name");
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        ASMMethodNodeAdapter methodNode = this.classNode.getDeclaredMethod(methodName, desc);
        if (methodNode == null) {
            return null;
        }
        return new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
    }

    public InstrumentMethod getLambdaMethod(String ... parameterTypes) {
        return this.getDeclaredMethod("get$Lambda", parameterTypes);
    }

    public List<InstrumentMethod> getDeclaredMethods() {
        return this.getDeclaredMethods(MethodFilters.ACCEPT_ALL);
    }

    public List<InstrumentMethod> getDeclaredMethods(MethodFilter methodFilter) {
        Objects.requireNonNull(methodFilter, "methodFilter");
        ArrayList<InstrumentMethod> candidateList = new ArrayList<InstrumentMethod>();
        for (ASMMethodNodeAdapter methodNode : this.classNode.getDeclaredMethods()) {
            ASMMethod method = new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
            if (!methodFilter.accept((InstrumentMethod)method)) continue;
            candidateList.add(method);
        }
        return candidateList;
    }

    public InstrumentMethod getConstructor(String ... parameterTypes) {
        return this.getDeclaredMethod("<init>", parameterTypes);
    }

    public List<InstrumentMethod> getDeclaredConstructors() {
        ArrayList<InstrumentMethod> candidateList = new ArrayList<InstrumentMethod>();
        for (ASMMethodNodeAdapter methodNode : this.classNode.getDeclaredConstructors()) {
            ASMMethod method = new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
            candidateList.add(method);
        }
        return candidateList;
    }

    public boolean hasDeclaredMethod(String methodName, String ... parameterTypes) {
        Objects.requireNonNull(methodName, "methodName");
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        return this.classNode.hasDeclaredMethod(methodName, desc);
    }

    public boolean hasMethod(String methodName, String ... parameterTypes) {
        Objects.requireNonNull(methodName, "methodName");
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        return this.classNode.hasMethod(methodName, desc);
    }

    public boolean hasEnclosingMethod(String methodName, String ... parameterTypes) {
        Objects.requireNonNull(methodName, "methodName");
        String desc = JavaAssistUtils.javaTypeToJvmSignature(parameterTypes);
        return this.classNode.hasOutClass(methodName, desc);
    }

    public boolean hasConstructor(String ... parameterTypeArray) {
        return this.getConstructor(parameterTypeArray) != null;
    }

    public boolean hasField(String fieldName, String type) {
        Objects.requireNonNull(fieldName, "name");
        String desc = type == null ? null : JavaAssistUtils.toJvmSignature(type);
        return this.classNode.getField(fieldName, desc) != null;
    }

    public boolean hasField(String name) {
        return this.hasField(name, null);
    }

    public void weave(String adviceClassName) throws InstrumentException {
        Objects.requireNonNull(adviceClassName, "adviceClassName");
        String classInternalName = JavaAssistUtils.javaNameToJvmName(adviceClassName);
        ClassLoader classLoader = this.classNode.getClassLoader();
        ProtectionDomain protectionDomain = this.classNode.getProtectionDomain();
        ASMClassNodeAdapter adviceClassNode = ASMClassNodeAdapter.get((ClassInputStreamProvider)this.pluginContext, classLoader, protectionDomain, classInternalName);
        if (adviceClassNode == null) {
            throw new NotFoundInstrumentException(adviceClassName + " not found.");
        }
        ASMAspectWeaver aspectWeaver = new ASMAspectWeaver();
        aspectWeaver.weaving(this.classNode, adviceClassNode);
        this.setModified(true);
    }

    public InstrumentMethod addDelegatorMethod(String methodName, String ... paramTypes) throws InstrumentException {
        Objects.requireNonNull(methodName, "methodName");
        if (this.getDeclaredMethod(methodName, paramTypes) != null) {
            throw new InstrumentException(this.getName() + " already have method(" + methodName + ").");
        }
        ASMClassNodeAdapter superClassNode = ASMClassNodeAdapter.get((ClassInputStreamProvider)this.pluginContext, this.classNode.getClassLoader(), this.classNode.getProtectionDomain(), this.classNode.getSuperClassInternalName());
        if (superClassNode == null) {
            throw new NotFoundInstrumentException(this.getName() + " not found super class(" + this.classNode.getSuperClassInternalName() + ")");
        }
        String desc = JavaAssistUtils.javaTypeToJvmSignature(paramTypes);
        ASMMethodNodeAdapter superMethodNode = superClassNode.getDeclaredMethod(methodName, desc);
        if (superMethodNode == null) {
            throw new NotFoundInstrumentException(methodName + desc + " is not found in " + superClassNode.getInternalName());
        }
        ASMMethodNodeAdapter methodNode = this.classNode.addDelegatorMethod(superMethodNode);
        this.setModified(true);
        return new ASMMethod(this.engineComponent, this.pluginContext, this, methodNode);
    }

    public void addField(Class<?> accessorClass) throws InstrumentException {
        Objects.requireNonNull(accessorClass, "accessorClass");
        try {
            AccessorAnalyzer accessorAnalyzer = new AccessorAnalyzer();
            AccessorAnalyzer.AccessorDetails accessorDetails = accessorAnalyzer.analyze(accessorClass);
            Type type = Type.getType(accessorDetails.getFieldType());
            String accessorTypeName = accessorClass.getName();
            String fieldName = FIELD_PREFIX + JavaAssistUtils.javaClassNameToVariableName(accessorTypeName);
            ASMFieldNodeAdapter fieldNode = this.classNode.addField(fieldName, type.getDescriptor());
            this.classNode.addInterface(accessorTypeName);
            this.classNode.addGetterMethod(accessorDetails.getGetter().getName(), fieldNode);
            this.classNode.addSetterMethod(accessorDetails.getSetter().getName(), fieldNode);
            this.setModified(true);
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add field with accessor [" + accessorClass.getName() + "]. Cause:" + e.getMessage(), (Throwable)e);
        }
    }

    public void addGetter(Class<?> getterClass, String fieldName) throws InstrumentException {
        Objects.requireNonNull(getterClass, "getterClass");
        Objects.requireNonNull(fieldName, "fieldName");
        try {
            GetterAnalyzer.GetterDetails getterDetails = new GetterAnalyzer().analyze(getterClass);
            ASMFieldNodeAdapter fieldNode = this.classNode.getField(fieldName, null);
            if (fieldNode == null) {
                throw new IllegalArgumentException("Not found field. name=" + fieldName);
            }
            String fieldTypeName = JavaAssistUtils.javaClassNameToObjectName(getterDetails.getFieldType().getName());
            if (!fieldNode.getClassName().equals(fieldTypeName)) {
                throw new IllegalArgumentException("different return type. return=" + fieldTypeName + ", field=" + fieldNode.getClassName());
            }
            this.classNode.addGetterMethod(getterDetails.getGetter().getName(), fieldNode);
            this.classNode.addInterface(getterClass.getName());
            this.setModified(true);
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add getter: " + getterClass.getName(), (Throwable)e);
        }
    }

    public void addSetter(Class<?> setterClass, String fieldName) throws InstrumentException {
        this.addSetter(setterClass, fieldName, false);
    }

    public void addSetter(Class<?> setterClass, String fieldName, boolean removeFinal) throws InstrumentException {
        Objects.requireNonNull(setterClass, "setterClass");
        try {
            SetterAnalyzer.SetterDetails setterDetails = new SetterAnalyzer().analyze(setterClass);
            ASMFieldNodeAdapter fieldNode = this.classNode.getField(fieldName, null);
            if (fieldNode == null) {
                throw new IllegalArgumentException("Not found field. name=" + fieldName);
            }
            String fieldTypeName = JavaAssistUtils.javaClassNameToObjectName(setterDetails.getFieldType().getName());
            if (!fieldNode.getClassName().equals(fieldTypeName)) {
                throw new IllegalArgumentException("Argument type of the setter is different with the field type. setterMethod: " + fieldTypeName + ", fieldType: " + fieldNode.getClassName());
            }
            if (fieldNode.isStatic()) {
                throw new IllegalArgumentException("Cannot add setter to static fields. setterMethod: " + setterDetails.getSetter().getName() + ", fieldName: " + fieldName);
            }
            int original = fieldNode.getAccess();
            boolean finalRemoved = false;
            if (fieldNode.isFinal()) {
                if (!removeFinal) {
                    throw new IllegalArgumentException("Cannot add setter to final field. setterMethod: " + setterDetails.getSetter().getName() + ", fieldName: " + fieldName);
                }
                int removed = original & 0xFFFFFFEF;
                fieldNode.setAccess(removed);
                finalRemoved = true;
            }
            try {
                this.classNode.addSetterMethod(setterDetails.getSetter().getName(), fieldNode);
                this.classNode.addInterface(setterClass.getName());
                this.setModified(true);
            }
            catch (Exception e) {
                if (finalRemoved) {
                    fieldNode.setAccess(original);
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to add setter: " + setterClass.getName(), (Throwable)e);
        }
    }

    private Class<? extends Interceptor> loadInterceptorClass(String interceptorClassName) throws InstrumentException {
        try {
            ClassLoader classLoader = this.classNode.getClassLoader();
            return this.pluginContext.injectClass(classLoader, interceptorClassName);
        }
        catch (Exception ex) {
            throw new InstrumentException(interceptorClassName + " not found Caused by:" + ex.getMessage(), (Throwable)ex);
        }
    }

    private int addInterceptor0(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        TargetFilter targetFilter;
        TargetConstructor targetConstructor;
        TargetConstructors targetConstructors;
        TargetMethod targetMethod;
        int interceptorId = -1;
        TargetMethods targetMethods = interceptorClass.getAnnotation(TargetMethods.class);
        if (targetMethods != null) {
            for (TargetMethod m : targetMethods.value()) {
                interceptorId = this.addInterceptor0(m, interceptorClass, constructorArgs, scope, executionPolicy);
            }
        }
        if ((targetMethod = interceptorClass.getAnnotation(TargetMethod.class)) != null) {
            interceptorId = this.addInterceptor0(targetMethod, interceptorClass, constructorArgs, scope, executionPolicy);
        }
        if ((targetConstructors = interceptorClass.getAnnotation(TargetConstructors.class)) != null) {
            for (TargetConstructor c : targetConstructors.value()) {
                interceptorId = this.addInterceptor0(c, interceptorClass, scope, executionPolicy, constructorArgs);
            }
        }
        if ((targetConstructor = interceptorClass.getAnnotation(TargetConstructor.class)) != null) {
            interceptorId = this.addInterceptor0(targetConstructor, interceptorClass, scope, executionPolicy, constructorArgs);
        }
        if ((targetFilter = interceptorClass.getAnnotation(TargetFilter.class)) != null) {
            interceptorId = this.addInterceptor0(targetFilter, interceptorClass, scope, executionPolicy, constructorArgs);
        }
        if (interceptorId == -1) {
            throw new PinpointException("No target is specified. At least one of @Targets, @TargetMethod, @TargetConstructor, @TargetFilter must present. interceptor: " + interceptorClass.getName());
        }
        return interceptorId;
    }

    private int addInterceptor0(TargetConstructor c, Class<? extends Interceptor> interceptorClass, InterceptorScope scope, ExecutionPolicy executionPolicy, Object ... constructorArgs) throws InstrumentException {
        InstrumentMethod constructor = this.getConstructor(c.value());
        if (constructor == null) {
            throw new NotFoundInstrumentException("Cannot find constructor with parameter types: " + Arrays.toString(c.value()));
        }
        return ((ASMMethod)constructor).addInterceptorInternal(interceptorClass, constructorArgs, scope, executionPolicy);
    }

    private int addInterceptor0(TargetMethod m, Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope scope, ExecutionPolicy executionPolicy) throws InstrumentException {
        InstrumentMethod method = this.getDeclaredMethod(m.name(), m.paramTypes());
        if (method == null) {
            throw new NotFoundInstrumentException("Cannot find method " + m.name() + " with parameter types: " + Arrays.toString(m.paramTypes()));
        }
        return ((ASMMethod)method).addInterceptorInternal(interceptorClass, constructorArgs, scope, executionPolicy);
    }

    private int addInterceptor0(TargetFilter annotation, Class<? extends Interceptor> interceptorClass, InterceptorScope scope, ExecutionPolicy executionPolicy, Object[] constructorArgs) throws InstrumentException {
        String filterTypeName = annotation.type();
        Objects.requireNonNull(filterTypeName, "type of @TargetFilter");
        ObjectBinderFactory objectBinderFactory = this.engineComponent.getObjectBinderFactory();
        InterceptorArgumentProvider interceptorArgumentProvider = objectBinderFactory.newInterceptorArgumentProvider(this);
        AutoBindingObjectFactory filterFactory = objectBinderFactory.newAutoBindingObjectFactory(this.pluginContext, this.classNode.getClassLoader(), interceptorArgumentProvider);
        ObjectFactory objectFactory = ObjectFactory.byConstructor((String)filterTypeName, (Object[])annotation.constructorArguments());
        MethodFilter filter = (MethodFilter)filterFactory.createInstance(objectFactory, new ArgumentProvider[0]);
        boolean singleton = annotation.singleton();
        int interceptorId = -1;
        for (InstrumentMethod m : this.getDeclaredMethods(filter)) {
            if (singleton && interceptorId != -1) {
                m.addInterceptor(interceptorId);
                continue;
            }
            interceptorId = ((ASMMethod)m).addInterceptorInternal(interceptorClass, constructorArgs, scope, executionPolicy);
        }
        if (interceptorId == -1) {
            this.logger.warn("No methods are intercepted. target:{}, interceptor:{}, methodFilter:{} ", (Object)this.classNode.getInternalName(), interceptorClass, (Object)filterTypeName);
        }
        return interceptorId;
    }

    public int addInterceptor(Class<? extends Interceptor> interceptorClass) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        return this.addInterceptor0(interceptorClass, null, null, null);
    }

    public int addInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs ");
        return this.addInterceptor0(interceptorClass, constructorArgs, null, null);
    }

    public int addInterceptor(MethodFilter filter, Class<? extends Interceptor> interceptorClass) throws InstrumentException {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        return this.addScopedInterceptor0(filter, interceptorClass, null, null, null);
    }

    public int addInterceptor(MethodFilter filter, Class<? extends Interceptor> interceptorClass, Object[] constructorArgs) throws InstrumentException {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        return this.addScopedInterceptor0(filter, interceptorClass, constructorArgs, null, null);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, String scopeName) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClass, constructorArgs, interceptorScope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        return this.addInterceptor0(interceptorClass, constructorArgs, interceptorScope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClass, constructorArgs, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        return this.addInterceptor0(interceptorClass, constructorArgs, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, String scopeName) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClass, null, interceptorScope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, InterceptorScope interceptorScope) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(interceptorScope, "scope");
        return this.addInterceptor0(interceptorClass, null, interceptorScope, ExecutionPolicy.BOUNDARY);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addInterceptor0(interceptorClass, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        return this.addInterceptor0(interceptorClass, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, Class<? extends Interceptor> interceptorClass, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addScopedInterceptor0(filter, interceptorClass, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, Class<? extends Interceptor> interceptorClass, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        return this.addScopedInterceptor0(filter, interceptorClass, null, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(scopeName, "scopeName");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        return this.addScopedInterceptor0(filter, interceptorClass, constructorArgs, interceptorScope, executionPolicy);
    }

    public int addScopedInterceptor(MethodFilter filter, Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        return this.addScopedInterceptor0(filter, interceptorClass, constructorArgs, interceptorScope, executionPolicy);
    }

    private int addScopedInterceptor0(MethodFilter filter, Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        int interceptorId = -1;
        for (InstrumentMethod m : this.getDeclaredMethods(filter)) {
            if (interceptorId != -1) {
                m.addInterceptor(interceptorId);
                continue;
            }
            interceptorId = ((ASMMethod)m).addInterceptorInternal(interceptorClass, constructorArgs, interceptorScope, executionPolicy);
        }
        if (interceptorId == -1) {
            this.logger.warn("No methods are intercepted. target:{}, interceptor:{}, methodFilter:{}", (Object)this.classNode.getInternalName(), interceptorClass, (Object)filter.getClass().getName());
        }
        return interceptorId;
    }

    public List<InstrumentClass> getNestedClasses(ClassFilter filter) {
        Objects.requireNonNull(filter, "filter");
        ArrayList<InstrumentClass> nestedClasses = new ArrayList<InstrumentClass>();
        for (ASMClassNodeAdapter innerClassNode : this.classNode.getInnerClasses()) {
            ASMNestedClass nestedClass = new ASMNestedClass(this.engineComponent, this.pluginContext, innerClassNode);
            if (!filter.accept((InstrumentClass)nestedClass)) continue;
            nestedClasses.add(nestedClass);
        }
        return nestedClasses;
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    public byte[] toBytecode() {
        return this.classNode.toByteArray();
    }
}

