/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.grpc.trace.PActiveThreadDump;
import com.navercorp.pinpoint.grpc.trace.PActiveThreadLightDump;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadCountRes;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadDumpRes;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadLightDumpRes;
import com.navercorp.pinpoint.grpc.trace.PCmdEchoResponse;
import com.navercorp.pinpoint.grpc.trace.PMonitorInfo;
import com.navercorp.pinpoint.grpc.trace.PThreadDump;
import com.navercorp.pinpoint.grpc.trace.PThreadLightDump;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.thrift.dto.command.TActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TActiveThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadCountRes;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TCommandEcho;
import com.navercorp.pinpoint.thrift.dto.command.TMonitorInfo;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TThreadState;
import java.util.List;
import org.apache.thrift.TBase;

public class CommandGrpcToThriftMessageConverter
implements MessageConverter<Object, TBase<?, ?>> {
    @Override
    public TBase<?, ?> toMessage(Object message) {
        if (message instanceof PCmdEchoResponse) {
            return this.buildTCommandEcho((PCmdEchoResponse)message);
        }
        if (message instanceof PCmdActiveThreadCountRes) {
            return this.buildTCmdActiveThreadCountRes((PCmdActiveThreadCountRes)message);
        }
        if (message instanceof PCmdActiveThreadDumpRes) {
            return this.buildTCmdActiveThreadDumpRes((PCmdActiveThreadDumpRes)message);
        }
        if (message instanceof PCmdActiveThreadLightDumpRes) {
            return this.buildTCmdActiveThreadLightDumpRes((PCmdActiveThreadLightDumpRes)message);
        }
        return null;
    }

    private TCommandEcho buildTCommandEcho(PCmdEchoResponse echoMessage) {
        String message = echoMessage.getMessage();
        return new TCommandEcho(message);
    }

    private TCmdActiveThreadCountRes buildTCmdActiveThreadCountRes(PCmdActiveThreadCountRes activeThreadCountRes) {
        int histogramSchemaType = activeThreadCountRes.getHistogramSchemaType();
        List activeThreadCountList = activeThreadCountRes.getActiveThreadCountList();
        long timeStamp = activeThreadCountRes.getTimeStamp();
        TCmdActiveThreadCountRes result = new TCmdActiveThreadCountRes(histogramSchemaType, activeThreadCountList);
        result.setTimeStamp(timeStamp);
        return result;
    }

    private TCmdActiveThreadDumpRes buildTCmdActiveThreadDumpRes(PCmdActiveThreadDumpRes pCmdActiveThreadDumpRes) {
        TCmdActiveThreadDumpRes tCmdActiveThreadDumpRes = new TCmdActiveThreadDumpRes();
        tCmdActiveThreadDumpRes.setVersion(pCmdActiveThreadDumpRes.getVersion());
        tCmdActiveThreadDumpRes.setType(pCmdActiveThreadDumpRes.getType());
        tCmdActiveThreadDumpRes.setSubType(pCmdActiveThreadDumpRes.getSubType());
        for (PActiveThreadDump pActiveThreadDump : pCmdActiveThreadDumpRes.getThreadDumpList()) {
            tCmdActiveThreadDumpRes.addToThreadDumps(this.buildTActiveThreadDump(pActiveThreadDump));
        }
        return tCmdActiveThreadDumpRes;
    }

    private TActiveThreadDump buildTActiveThreadDump(PActiveThreadDump pActiveThreadDump) {
        TActiveThreadDump tActiveThreadDump = new TActiveThreadDump();
        tActiveThreadDump.setStartTime(pActiveThreadDump.getStartTime());
        tActiveThreadDump.setSampled(pActiveThreadDump.getSampled());
        if (pActiveThreadDump.getSampled()) {
            tActiveThreadDump.setLocalTraceId(pActiveThreadDump.getLocalTraceId());
            tActiveThreadDump.setTransactionId(pActiveThreadDump.getTransactionId());
            tActiveThreadDump.setEntryPoint(pActiveThreadDump.getEntryPoint());
        }
        tActiveThreadDump.setThreadDump(this.buildTThreadDump(pActiveThreadDump.getThreadDump()));
        return tActiveThreadDump;
    }

    private TThreadDump buildTThreadDump(PThreadDump pThreadDump) {
        TThreadDump tThreadDump = new TThreadDump();
        tThreadDump.setThreadName(pThreadDump.getThreadName());
        tThreadDump.setThreadId(pThreadDump.getThreadId());
        tThreadDump.setBlockedTime(pThreadDump.getBlockedTime());
        tThreadDump.setBlockedCount(pThreadDump.getBlockedCount());
        tThreadDump.setWaitedTime(pThreadDump.getWaitedTime());
        tThreadDump.setWaitedCount(pThreadDump.getWaitedCount());
        tThreadDump.setInNative(pThreadDump.getInNative());
        tThreadDump.setSuspended(pThreadDump.getSuspended());
        tThreadDump.setThreadState(TThreadState.findByValue((int)pThreadDump.getThreadStateValue()));
        for (String stackTrace : pThreadDump.getStackTraceList()) {
            tThreadDump.addToStackTrace(stackTrace);
        }
        for (PMonitorInfo pMonitorInfo : pThreadDump.getLockedMonitorList()) {
            TMonitorInfo tMonitorInfo = new TMonitorInfo();
            tMonitorInfo.setStackDepth(pMonitorInfo.getStackDepth());
            tMonitorInfo.setStackFrame(pMonitorInfo.getStackFrame());
            tThreadDump.addToLockedMonitors(tMonitorInfo);
        }
        tThreadDump.setLockName(pThreadDump.getLockName());
        tThreadDump.setLockOwnerId(pThreadDump.getLockOwnerId());
        tThreadDump.setLockOwnerName(pThreadDump.getLockOwnerName());
        for (String lockedSynchronizer : pThreadDump.getLockedSynchronizerList()) {
            tThreadDump.addToLockedSynchronizers(lockedSynchronizer);
        }
        return tThreadDump;
    }

    private TCmdActiveThreadLightDumpRes buildTCmdActiveThreadLightDumpRes(PCmdActiveThreadLightDumpRes pCmdActiveThreadLightDumpRes) {
        TCmdActiveThreadLightDumpRes tCmdActiveThreadLightDumpRes = new TCmdActiveThreadLightDumpRes();
        tCmdActiveThreadLightDumpRes.setVersion(pCmdActiveThreadLightDumpRes.getVersion());
        tCmdActiveThreadLightDumpRes.setType(pCmdActiveThreadLightDumpRes.getType());
        tCmdActiveThreadLightDumpRes.setSubType(pCmdActiveThreadLightDumpRes.getSubType());
        for (PActiveThreadLightDump pActiveThreadLightDump : pCmdActiveThreadLightDumpRes.getThreadDumpList()) {
            tCmdActiveThreadLightDumpRes.addToThreadDumps(this.buildTActiveThreadLightDump(pActiveThreadLightDump));
        }
        return tCmdActiveThreadLightDumpRes;
    }

    private TActiveThreadLightDump buildTActiveThreadLightDump(PActiveThreadLightDump pActiveThreadLightDump) {
        TActiveThreadLightDump tActiveThreadLightDump = new TActiveThreadLightDump();
        tActiveThreadLightDump.setStartTime(pActiveThreadLightDump.getStartTime());
        tActiveThreadLightDump.setSampled(pActiveThreadLightDump.getSampled());
        if (pActiveThreadLightDump.getSampled()) {
            tActiveThreadLightDump.setLocalTraceId(pActiveThreadLightDump.getLocalTraceId());
            tActiveThreadLightDump.setTransactionId(pActiveThreadLightDump.getTransactionId());
            tActiveThreadLightDump.setEntryPoint(pActiveThreadLightDump.getEntryPoint());
        }
        tActiveThreadLightDump.setThreadDump(this.buildTThreadLightDump(pActiveThreadLightDump.getThreadDump()));
        return tActiveThreadLightDump;
    }

    private TThreadLightDump buildTThreadLightDump(PThreadLightDump pThreadDump) {
        TThreadLightDump tThreadLightDump = new TThreadLightDump();
        tThreadLightDump.setThreadId(pThreadDump.getThreadId());
        tThreadLightDump.setThreadName(pThreadDump.getThreadName());
        tThreadLightDump.setThreadState(TThreadState.findByValue((int)pThreadDump.getThreadStateValue()));
        return tThreadLightDump;
    }
}

