/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.module.PluginJars;
import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class PluginClassLoaderProvider
implements Provider<ClassLoader> {
    private final ClassLoader pluginClassLoader;

    @Inject
    public PluginClassLoaderProvider(@PluginJars List<PluginJar> pluginJars) {
        ClassLoader parentClassLoader = Object.class.getClassLoader();
        ArrayList<URL> pluginUrls = new ArrayList<URL>(pluginJars.size());
        for (PluginJar pluginJar : pluginJars) {
            pluginUrls.add(pluginJar.getURL());
        }
        URL[] urls = pluginUrls.toArray(new URL[0]);
        this.pluginClassLoader = this.createPluginClassLoader(urls, parentClassLoader);
    }

    private ClassLoader createPluginClassLoader(final URL[] urls, final ClassLoader parentClassLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new URLClassLoader(urls, parentClassLoader);
                }
            });
        }
        return new URLClassLoader(urls, parentClassLoader);
    }

    public ClassLoader get() {
        return this.pluginClassLoader;
    }
}

