/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.monitor.metric;

import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.CustomMetric;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.DoubleGauge;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.IntCounter;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.IntGauge;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.LongCounter;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.LongGauge;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricIdGenerator;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryFilter;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricWrapperFactory;
import com.navercorp.pinpoint.profiler.context.monitor.metric.DefaultCustomMetricRegistryFilter;
import com.navercorp.pinpoint.profiler.context.monitor.metric.DoubleGaugeWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.metric.IntCounterWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.metric.IntGaugeWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.metric.LongCounterWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.metric.LongGaugeWrapper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultCustomMetricRegistryService
implements CustomMetricRegistryService {
    private static final Logger LOGGER = LogManager.getLogger(DefaultCustomMetricRegistryService.class);
    private final CustomMetricWrapperFactory customMetricWrapperFactory = new CustomMetricWrapperFactory();
    private final Map<String, CustomMetricWrapper> customMetricWrapperMap = new ConcurrentHashMap<String, CustomMetricWrapper>();
    private final CustomMetricIdGenerator customMetricIdGenerator;
    private final CustomMetricRegistryFilter filter;

    public DefaultCustomMetricRegistryService(int limitIdNumber) {
        this(limitIdNumber, new DefaultCustomMetricRegistryFilter());
    }

    public DefaultCustomMetricRegistryService(int limitIdNumber, CustomMetricRegistryFilter filter) {
        this.customMetricIdGenerator = new CustomMetricIdGenerator(limitIdNumber);
        this.filter = Objects.requireNonNull(filter, "filter");
    }

    @Override
    public boolean register(IntCounter intCounter) {
        Objects.requireNonNull(intCounter, "intCount");
        boolean filter = this.filter.filter(intCounter);
        if (filter) {
            LOGGER.warn("Failed to register CustomMetric({}). message:not allowed metric", (Object)intCounter);
            return false;
        }
        int id = this.customMetricIdGenerator.create(intCounter.getName());
        if (id == -1) {
            LOGGER.warn("Failed to create metricId. metric:{}", (Object)intCounter);
            return false;
        }
        IntCounterWrapper customMetricWrapper = this.customMetricWrapperFactory.create(id, intCounter);
        return this.add(customMetricWrapper);
    }

    @Override
    public boolean register(LongCounter longCounter) {
        Objects.requireNonNull(longCounter, "longCount");
        boolean filter = this.filter.filter(longCounter);
        if (filter) {
            LOGGER.warn("Failed to register CustomMetric({}). message:not allowed metric", (Object)longCounter);
            return false;
        }
        int id = this.customMetricIdGenerator.create(longCounter.getName());
        if (id == -1) {
            LOGGER.warn("Failed to create metricId. metric:{}", (Object)longCounter);
            return false;
        }
        LongCounterWrapper customMetricWrapper = this.customMetricWrapperFactory.create(id, longCounter);
        return this.add(customMetricWrapper);
    }

    @Override
    public boolean register(IntGauge intGauge) {
        Objects.requireNonNull(intGauge, "intGauge");
        boolean filter = this.filter.filter(intGauge);
        if (filter) {
            LOGGER.warn("Failed to register CustomMetric({}). message:not allowed metric", (Object)intGauge);
            return false;
        }
        int id = this.customMetricIdGenerator.create(intGauge.getName());
        if (id == -1) {
            LOGGER.warn("Failed to create metricId. metric:{}", (Object)intGauge);
            return false;
        }
        IntGaugeWrapper customMetricWrapper = this.customMetricWrapperFactory.create(id, intGauge);
        return this.add(customMetricWrapper);
    }

    @Override
    public boolean register(LongGauge longGauge) {
        Objects.requireNonNull(longGauge, "longGauge");
        boolean filter = this.filter.filter(longGauge);
        if (filter) {
            LOGGER.warn("Failed to register CustomMetric({}). message:not allowed metric", (Object)longGauge);
            return false;
        }
        int id = this.customMetricIdGenerator.create(longGauge.getName());
        if (id == -1) {
            LOGGER.warn("Failed to create metricId. metric:{}", (Object)longGauge);
            return false;
        }
        LongGaugeWrapper customMetricWrapper = this.customMetricWrapperFactory.create(id, longGauge);
        return this.add(customMetricWrapper);
    }

    @Override
    public boolean register(DoubleGauge doubleGauge) {
        Objects.requireNonNull(doubleGauge, "doubleGauge");
        boolean filter = this.filter.filter(doubleGauge);
        if (filter) {
            LOGGER.warn("Failed to register CustomMetric({}). message:not allowed metric", (Object)doubleGauge);
            return false;
        }
        int id = this.customMetricIdGenerator.create(doubleGauge.getName());
        if (id == -1) {
            LOGGER.warn("Failed to create metricId. metric:{}", (Object)doubleGauge);
            return false;
        }
        DoubleGaugeWrapper customMetricWrapper = this.customMetricWrapperFactory.create(id, doubleGauge);
        return this.add(customMetricWrapper);
    }

    private boolean add(CustomMetricWrapper customMetricWrapper) {
        CustomMetricWrapper put = this.customMetricWrapperMap.put(customMetricWrapper.getName(), customMetricWrapper);
        return put == null;
    }

    @Override
    public boolean unregister(IntCounter customMetric) {
        return this.remove((CustomMetric)customMetric);
    }

    @Override
    public boolean unregister(LongCounter customMetric) {
        return this.remove((CustomMetric)customMetric);
    }

    @Override
    public boolean unregister(IntGauge customMetric) {
        return this.remove((CustomMetric)customMetric);
    }

    @Override
    public boolean unregister(LongGauge customMetric) {
        return this.remove((CustomMetric)customMetric);
    }

    @Override
    public boolean unregister(DoubleGauge customMetric) {
        return this.remove((CustomMetric)customMetric);
    }

    private boolean remove(CustomMetric customMetric) {
        CustomMetricWrapper customMetricWrapper = this.customMetricWrapperMap.get(customMetric.getName());
        if (customMetricWrapper == null) {
            return false;
        }
        if (customMetricWrapper.equalsWithUnwrap(customMetric)) {
            CustomMetricWrapper remove = this.customMetricWrapperMap.remove(customMetric.getName());
            return remove != null;
        }
        return false;
    }

    @Override
    public Map<String, CustomMetricWrapper> getCustomMetricMap() {
        return this.customMetricWrapperMap;
    }
}

