/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncTrace
implements Trace {
    private static final Logger logger = LogManager.getLogger((String)AsyncTrace.class.getName());
    private static final boolean isDebug = logger.isDebugEnabled();
    private final TraceRoot traceRoot;
    private final DefaultTrace trace;
    private final AsyncState asyncState;

    public AsyncTrace(TraceRoot traceRoot, DefaultTrace trace, AsyncState asyncState) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.trace = Objects.requireNonNull(trace, "trace");
        this.asyncState = Objects.requireNonNull(asyncState, "asyncState");
    }

    public long getId() {
        return this.traceRoot.getLocalTransactionId();
    }

    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    public TraceId getTraceId() {
        return this.traceRoot.getTraceId();
    }

    public boolean canSampled() {
        return this.trace.canSampled();
    }

    public boolean isRoot() {
        return this.traceRoot.getTraceId().isRoot();
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.trace.traceBlockBegin();
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        return this.trace.traceBlockBegin(stackId);
    }

    public void traceBlockEnd() {
        this.trace.traceBlockEnd();
    }

    public void traceBlockEnd(int stackId) {
        this.trace.traceBlockEnd(stackId);
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        return this.trace.isRootStack();
    }

    public boolean isClosed() {
        return this.trace.isClosed();
    }

    public void close() {
        if (this.asyncState.await()) {
            this.trace.flush();
            if (isDebug) {
                logger.debug("Flush trace={}, asyncState={}", (Object)this, (Object)this.asyncState);
            }
        } else {
            this.trace.close();
            if (isDebug) {
                logger.debug("Close trace={}. asyncState={}", (Object)this, (Object)this.asyncState);
            }
        }
    }

    public SpanRecorder getSpanRecorder() {
        return this.trace.getSpanRecorder();
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        return this.trace.currentSpanEventRecorder();
    }

    public int getCallStackFrameId() {
        return this.trace.getCallStackFrameId();
    }

    public TraceScope getScope(String name) {
        return this.trace.getScope(name);
    }

    public TraceScope addScope(String name) {
        return this.trace.addScope(name);
    }

    public String toString() {
        return "AsyncTrace{traceRoot=" + this.traceRoot + ", trace=" + this.trace + ", asyncState=" + this.asyncState + '}';
    }
}

