/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.reactor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AsyncContextSpanEventSimpleAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.reactor.ReactorContextAccessorUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;

public class FluxAndMonoOperatorSubscribeInterceptor
extends AsyncContextSpanEventSimpleAroundInterceptor {
    private final ServiceType serviceType;

    public FluxAndMonoOperatorSubscribeInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, ServiceType serviceType) {
        super(traceContext, methodDescriptor);
        this.serviceType = serviceType;
    }

    @Override
    public AsyncContext getAsyncContext(Object target, Object[] args) {
        if (this.checkTargetReactorContextAccessor(target, args)) {
            return AsyncContextAccessorUtils.getAsyncContext(target);
        }
        if (this.checkTargetAsyncContextAccessor(target, args)) {
            return AsyncContextAccessorUtils.getAsyncContext(target);
        }
        if (this.checkSubscriberReactorContextAccessor(target, args)) {
            return AsyncContextAccessorUtils.getAsyncContext(target);
        }
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    boolean checkTargetReactorContextAccessor(Object target, Object[] args) {
        AsyncContext asyncContext = ReactorContextAccessorUtils.getAsyncContext(target);
        if (asyncContext != null) {
            this.setReactorContextToSubscriber(asyncContext, args);
            return true;
        }
        return false;
    }

    boolean checkTargetAsyncContextAccessor(Object target, Object[] args) {
        AsyncContext asyncContext = AsyncContextAccessorUtils.getAsyncContext(target);
        if (asyncContext != null) {
            this.setReactorContextToTarget(asyncContext, target);
            this.setReactorContextToSubscriber(asyncContext, args);
            return true;
        }
        return false;
    }

    boolean checkSubscriberReactorContextAccessor(Object target, Object[] args) {
        AsyncContext asyncContext = ReactorContextAccessorUtils.getAsyncContext(args, 0);
        if (asyncContext != null) {
            this.setReactorContextToTarget(asyncContext, target);
            return true;
        }
        return false;
    }

    protected void setReactorContextToTarget(AsyncContext asyncContext, Object target) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, target);
    }

    protected void setReactorContextToSubscriber(AsyncContext asyncContext, Object[] args) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, args, 0);
    }

    @Override
    public void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
    }

    @Override
    public AsyncContext getAsyncContext(Object target, Object[] args, Object result, Throwable throwable) {
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    @Override
    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(this.serviceType);
        recorder.recordException(throwable);
    }
}

