/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.http;

import com.navercorp.pinpoint.bootstrap.config.HttpStatusCodeErrors;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;

public class HttpStatusCodeRecorder {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final HttpStatusCodeErrors errors;

    public HttpStatusCodeRecorder(HttpStatusCodeErrors errors) {
        this.errors = errors;
    }

    public void record(SpanRecorder spanRecorder, int statusCode) {
        if (spanRecorder == null) {
            return;
        }
        if (!this.errors.isHttpStatusCode(statusCode)) {
            if (this.isDebug) {
                this.logger.debug("Out of range HTTP status code. statusCode={}", (Object)statusCode);
            }
            return;
        }
        spanRecorder.recordStatusCode(statusCode);
        if (this.isDebug) {
            this.logger.debug("Record HTTP status code annotation. statusCode={}", (Object)statusCode);
        }
        if (this.errors.isErrorCode(statusCode)) {
            spanRecorder.recordError();
            if (this.isDebug) {
                this.logger.debug("Record https.status.code error code:{}", (Object)statusCode);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpStatusCodeRecorder{");
        sb.append(", errors=").append(this.errors);
        sb.append('}');
        return sb.toString();
    }
}

