/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.classloader;

import com.navercorp.pinpoint.bootstrap.classloader.BootLoader;
import com.navercorp.pinpoint.bootstrap.classloader.J9BootLoader;
import com.navercorp.pinpoint.bootstrap.classloader.LauncherBootLoader;
import com.navercorp.pinpoint.common.util.JvmType;
import com.navercorp.pinpoint.common.util.JvmUtils;

public final class BootLoaderFactory {
    private static final boolean isJ9Vm = BootLoaderFactory.isJ9VM();

    private BootLoaderFactory() {
    }

    public static BootLoader newBootLoader() {
        if (isJ9Vm) {
            try {
                return new J9BootLoader();
            }
            catch (Error linkageError) {
                throw new IllegalStateException("J9BootLoader create fail Caused by:" + linkageError.getMessage(), linkageError);
            }
        }
        return new LauncherBootLoader();
    }

    private static boolean isJ9VM() {
        JvmType jvmType = JvmUtils.getType();
        return jvmType == JvmType.IBM;
    }
}

