/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.GetResponse;
import io.cloudevents.CloudEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.connector.rabbitmq.cloudevent.RabbitmqCloudEvent;
import org.apache.eventmesh.connector.rabbitmq.config.ConfigurationHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqConsumerHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RabbitmqConsumerHandler.class);
    private final Channel channel;
    private final ConfigurationHolder configurationHolder;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private EventListener eventListener;

    public RabbitmqConsumerHandler(Channel channel, ConfigurationHolder configurationHolder) {
        this.channel = channel;
        this.configurationHolder = configurationHolder;
    }

    @Override
    public void run() {
        while (!this.stop.get()) {
            try {
                GetResponse response = this.channel.basicGet(this.configurationHolder.getQueueName(), this.configurationHolder.isAutoAck());
                if (response == null) continue;
                RabbitmqCloudEvent rabbitmqCloudEvent = RabbitmqCloudEvent.getFromByteArray(response.getBody());
                CloudEvent cloudEvent = rabbitmqCloudEvent.convertToCloudEvent();
                EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                    public void commit(EventMeshAction action) {
                        logger.info("[RabbitmqConsumerHandler] Rabbitmq consumer context commit.");
                    }
                };
                if (this.eventListener != null) {
                    this.eventListener.consume(cloudEvent, (AsyncConsumeContext)consumeContext);
                }
                if (this.configurationHolder.isAutoAck()) continue;
                this.channel.basicAck(response.getEnvelope().getDeliveryTag(), false);
            }
            catch (Exception ex) {
                logger.error("[RabbitmqConsumerHandler] thread run happen exception.", (Throwable)ex);
            }
        }
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void stop() {
        this.stop.set(true);
    }
}

