/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.notifications.notifier;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.notifications.Listener;
import io.pravega.client.stream.notifications.NotificationSystem;
import io.pravega.client.stream.notifications.SegmentNotification;
import io.pravega.client.stream.notifications.notifier.AbstractPollingNotifier;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNotifier
extends AbstractPollingNotifier<SegmentNotification> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentNotifier.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final int UPDATE_INTERVAL_SECONDS = Integer.parseInt(System.getProperty("pravega.client.segmentNotification.poll.interval.seconds", String.valueOf(120)));
    @GuardedBy(value="$lock")
    private int numberOfSegments = 0;

    public SegmentNotifier(NotificationSystem notifySystem, StateSynchronizer<ReaderGroupState> synchronizer, ScheduledExecutorService executor) {
        super(notifySystem, executor, synchronizer);
    }

    @VisibleForTesting
    public void pollNow() {
        this.checkAndTriggerSegmentNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(Listener<SegmentNotification> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.notifySystem.addListeners(this.getType(), listener, this.executor);
            this.startPolling(this::checkAndTriggerSegmentNotification, UPDATE_INTERVAL_SECONDS);
        }
    }

    @Override
    public String getType() {
        return SegmentNotification.class.getSimpleName();
    }

    private void checkAndTriggerSegmentNotification() {
        this.synchronizer.fetchUpdates();
        ReaderGroupState state = (ReaderGroupState)this.synchronizer.getState();
        if (state == null) {
            log.warn("Current state of StateSynchronizer {} is null, will try again.", (Object)this.synchronizer);
        } else {
            int newNumberOfSegments = state.getNumberOfSegments();
            log.debug("Number of segments in {} is {}", (Object)this.synchronizer, (Object)newNumberOfSegments);
            Preconditions.checkState((newNumberOfSegments > 0 ? 1 : 0) != 0, (Object)"Number of segments cannot be zero");
            if (this.numberOfSegments != newNumberOfSegments) {
                this.numberOfSegments = newNumberOfSegments;
                SegmentNotification notification = SegmentNotification.builder().numOfSegments(state.getNumberOfSegments()).numOfReaders(state.getOnlineReaders().size()).build();
                this.notifySystem.notify(notification);
            }
        }
    }
}

