/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class EventMeshThreadFactoryImpl
implements ThreadFactory {
    private final AtomicLong threadIndex = new AtomicLong(0L);
    private final String threadNamePrefix;
    private Boolean isDaemonSpecified = null;

    public EventMeshThreadFactoryImpl(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public EventMeshThreadFactoryImpl(String threadNamePrefix, boolean isDaemonSpecified) {
        this.threadNamePrefix = threadNamePrefix;
        this.isDaemonSpecified = isDaemonSpecified;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.threadNamePrefix + '-' + this.threadIndex.incrementAndGet());
        if (this.isDaemonSpecified != null) {
            t.setDaemon(this.isDaemonSpecified);
        }
        return t;
    }
}

