/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartBeatTask.class);

    public HeartBeatTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Package res = new Package();
        try {
            if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable()) {
                String remoteAddr = RemotingHelper.parseChannelRemoteAddr(this.ctx.channel());
                Acl.doAclCheckInTcpHeartbeat(remoteAddr, this.session.getClient(), Command.HEARTBEAT_REQUEST.getValue());
            }
            if (this.session != null) {
                this.session.notifyHeartbeat(this.startTime);
            }
            res.setHeader(new Header(Command.HEARTBEAT_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            LOGGER.error("HeartBeatTask failed|user={}|errMsg={}", (Object)Objects.requireNonNull(this.session).getClient(), (Object)e);
            res.setHeader(new Header(Command.HEARTBEAT_RESPONSE, OPStatus.FAIL.getCode().intValue(), "exception while heartbeating", this.pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(res, this.startTime, taskExecuteTime, Objects.requireNonNull(this.session).getContext(), this.session);
        }
    }
}

