/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.opentelemetry.api.trace.Span;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.UpStreamMsgContext;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSender {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionSender.class);
    private final transient Session session;
    public transient long createTime = System.currentTimeMillis();
    public transient AtomicLong upMsgs = new AtomicLong(0L);
    public transient AtomicLong failMsgCount = new AtomicLong(0L);
    private static final int TRY_PERMIT_TIME_OUT = 5;
    private final Semaphore upstreamBuff;

    public String toString() {
        return "SessionSender{upstreamBuff=" + this.upstreamBuff.availablePermits() + ",upMsgs=" + this.upMsgs.longValue() + ",failMsgCount=" + this.failMsgCount.longValue() + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + '}';
    }

    public Semaphore getUpstreamBuff() {
        return this.upstreamBuff;
    }

    public SessionSender(Session session) {
        this.session = session;
        this.upstreamBuff = new Semaphore(session.getEventMeshTCPConfiguration().eventMeshTcpSessionUpstreamBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventMeshTcpSendResult send(Header header, CloudEvent event, SendCallback sendCallback, long startTime, long taskExecuteTime) {
        try {
            if (this.upstreamBuff.tryAcquire(5L, TimeUnit.MILLISECONDS)) {
                this.upMsgs.incrementAndGet();
                Command cmd = header.getCmd();
                String protocolVersion = header.getProperty("protocolversion").toString();
                long ttl = 3000L;
                if (Command.REQUEST_TO_SERVER == cmd) {
                    if (event.getExtension("ttl") != null) {
                        ttl = Long.parseLong((String)Objects.requireNonNull(event.getExtension("ttl")));
                    }
                    UpStreamMsgContext upStreamMsgContext = new UpStreamMsgContext(this.session, event, header, startTime, taskExecuteTime);
                    Span span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "upstream-eventmesh-client-span", false);
                    try {
                        ((ClientGroupWrapper)Objects.requireNonNull(this.session.getClientGroupWrapper().get())).request(upStreamMsgContext, this.initSyncRRCallback(header, startTime, taskExecuteTime, event), ttl);
                        this.upstreamBuff.release();
                    }
                    finally {
                        TraceUtils.finishSpan(span, event);
                    }
                } else if (Command.RESPONSE_TO_SERVER == cmd) {
                    String cluster = (String)event.getExtension("cluster");
                    if (!StringUtils.isEmpty((CharSequence)cluster)) {
                        String replyTopic = "rr-reply-topic";
                        replyTopic = cluster + "-" + replyTopic;
                        event = CloudEventBuilder.from((CloudEvent)event).withSubject(replyTopic).build();
                    }
                    UpStreamMsgContext upStreamMsgContext = new UpStreamMsgContext(this.session, event, header, startTime, taskExecuteTime);
                    ((ClientGroupWrapper)Objects.requireNonNull(this.session.getClientGroupWrapper().get())).reply(upStreamMsgContext);
                    this.upstreamBuff.release();
                } else {
                    UpStreamMsgContext upStreamMsgContext = new UpStreamMsgContext(this.session, event, header, startTime, taskExecuteTime);
                    Span span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, event), "upstream-eventmesh-client-span", false);
                    try {
                        ((ClientGroupWrapper)Objects.requireNonNull(this.session.getClientGroupWrapper().get())).send(upStreamMsgContext, sendCallback);
                    }
                    finally {
                        TraceUtils.finishSpan(span, event);
                    }
                }
            } else {
                LOGGER.warn("send too fast,session flow control,session:{}", (Object)this.session.getClient());
                return new EventMeshTcpSendResult(header.getSeq(), EventMeshTcpSendStatus.SEND_TOO_FAST, EventMeshTcpSendStatus.SEND_TOO_FAST.name());
            }
            ((ClientGroupWrapper)Objects.requireNonNull(this.session.getClientGroupWrapper().get())).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2mqMsgNum().incrementAndGet();
        }
        catch (Exception e) {
            LOGGER.warn("SessionSender send failed", (Throwable)e);
            if (!(e instanceof InterruptedException)) {
                this.upstreamBuff.release();
            }
            this.failMsgCount.incrementAndGet();
            return new EventMeshTcpSendResult(header.getSeq(), EventMeshTcpSendStatus.OTHER_EXCEPTION, e.getCause().toString());
        }
        return new EventMeshTcpSendResult(header.getSeq(), EventMeshTcpSendStatus.SUCCESS, EventMeshTcpSendStatus.SUCCESS.name());
    }

    private RequestReplyCallback initSyncRRCallback(final Header header, final long startTime, final long taskExecuteTime, final CloudEvent cloudEvent) {
        return new RequestReplyCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(CloudEvent event) {
                String seq = header.getSeq();
                event = CloudEventBuilder.from((CloudEvent)event).withExtension("rspmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("rspreceiveeventmeship", SessionSender.this.session.getEventMeshTCPConfiguration().getEventMeshServerIp()).build();
                ((ClientGroupWrapper)Objects.requireNonNull(SessionSender.this.session.getClientGroupWrapper().get())).getEventMeshTcpMonitor().getTcpSummaryMetrics().getMq2eventMeshMsgNum().incrementAndGet();
                if (Command.REQUEST_TO_SERVER != header.getCmd()) {
                    MESSAGE_LOGGER.error("invalid message|messageHeader={}|event={}", (Object)header, (Object)event);
                    return;
                }
                Command cmd = Command.RESPONSE_TO_CLIENT;
                event = CloudEventBuilder.from((CloudEvent)event).withExtension("rspeventmesh2ctimestamp", String.valueOf(System.currentTimeMillis())).build();
                String protocolType = Objects.requireNonNull(event.getExtension("protocoltype")).toString();
                ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
                Package pkg = new Package();
                try {
                    pkg = (Package)protocolAdaptor.fromCloudEvent(event);
                    pkg.setHeader(new Header(cmd, OPStatus.SUCCESS.getCode().intValue(), null, seq));
                    pkg.getHeader().putProperty("protocoltype", (Object)protocolType);
                }
                catch (Exception e) {
                    pkg.setHeader(new Header(cmd, OPStatus.FAIL.getCode().intValue(), null, seq));
                }
                finally {
                    Utils.writeAndFlush(pkg, startTime, taskExecuteTime, SessionSender.this.session.getContext(), SessionSender.this.session);
                    TraceUtils.finishSpan(SessionSender.this.session.getContext(), event);
                }
            }

            public void onException(Throwable e) {
                MESSAGE_LOGGER.error("exception occur while sending RR message|user={}", (Object)SessionSender.this.session.getClient(), (Object)new Exception(e));
                TraceUtils.finishSpanWithException(SessionSender.this.session.getContext(), cloudEvent, "exception occur while sending RR message", e);
            }
        };
    }
}

