/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry;

import io.cloudevents.CloudEvent;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public abstract class RetryContext
implements Delayed {
    public CloudEvent event;
    public String seq;
    public int retryTimes = 0;
    public long executeTime = System.currentTimeMillis();

    public RetryContext delay(long delay) {
        this.executeTime = System.currentTimeMillis() + (long)(this.retryTimes + 1) * delay;
        return this;
    }

    @Override
    public int compareTo(Delayed delayed) {
        RetryContext obj = (RetryContext)delayed;
        if (this.executeTime > obj.executeTime) {
            return 1;
        }
        if (this.executeTime == obj.executeTime) {
            return 0;
        }
        return -1;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.executeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public abstract void retry();
}

