/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventMeshRebalanceStrategy;
import org.apache.eventmesh.runtime.util.EventMeshThreadFactoryImpl;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshRebalanceService {
    protected final Logger logger = LoggerFactory.getLogger(EventMeshRebalanceService.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private Integer rebalanceIntervalMills;
    private EventMeshRebalanceStrategy rebalanceStrategy;
    private ScheduledExecutorService serviceRebalanceScheduler;

    public EventMeshRebalanceService(EventMeshTCPServer eventMeshTCPServer, EventMeshRebalanceStrategy rebalanceStrategy) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.rebalanceStrategy = rebalanceStrategy;
        this.rebalanceIntervalMills = eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpRebalanceIntervalInMills;
    }

    public void init() {
        this.serviceRebalanceScheduler = ThreadPoolFactory.createScheduledExecutor((int)5, (ThreadFactory)new EventMeshThreadFactoryImpl("proxy-rebalance-sch", true));
        this.logger.info("rebalance service inited......");
    }

    public void start() throws Exception {
        this.rebalanceStrategy.doRebalance();
        this.serviceRebalanceScheduler.scheduleAtFixedRate(() -> {
            try {
                this.rebalanceStrategy.doRebalance();
            }
            catch (Exception ex) {
                this.logger.error("RebalanceByService failed", (Throwable)ex);
            }
        }, this.rebalanceIntervalMills.intValue(), this.rebalanceIntervalMills.intValue(), TimeUnit.MILLISECONDS);
        this.logger.info("rebalance service started......");
    }

    public void shutdown() {
        this.serviceRebalanceScheduler.shutdown();
        this.logger.info("rebalance service shutdown......");
    }

    public void printRebalanceThreadPoolState() {
        EventMeshUtil.printState((ThreadPoolExecutor)((Object)this.serviceRebalanceScheduler));
    }
}

