/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.producer;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ProducerGroupConf;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerManager {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventMeshHTTPServer eventMeshHTTPServer;
    private ConcurrentHashMap<String, EventMeshProducer> producerTable = new ConcurrentHashMap();

    public ProducerManager(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void init() throws Exception {
        this.logger.info("producerManager inited......");
    }

    public void start() throws Exception {
        this.logger.info("producerManager started......");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventMeshProducer getEventMeshProducer(String producerGroup) throws Exception {
        EventMeshProducer eventMeshProducer = null;
        if (!this.producerTable.containsKey(producerGroup)) {
            ConcurrentHashMap<String, EventMeshProducer> concurrentHashMap = this.producerTable;
            synchronized (concurrentHashMap) {
                if (!this.producerTable.containsKey(producerGroup)) {
                    ProducerGroupConf producerGroupConfig = new ProducerGroupConf(producerGroup);
                    eventMeshProducer = this.createEventMeshProducer(producerGroupConfig);
                    eventMeshProducer.start();
                }
            }
        }
        if (!(eventMeshProducer = this.producerTable.get(producerGroup)).getStarted().get()) {
            eventMeshProducer.start();
        }
        return eventMeshProducer;
    }

    public synchronized EventMeshProducer createEventMeshProducer(ProducerGroupConf producerGroupConfig) throws Exception {
        if (this.producerTable.containsKey(producerGroupConfig.getGroupName())) {
            return this.producerTable.get(producerGroupConfig.getGroupName());
        }
        EventMeshProducer eventMeshProducer = new EventMeshProducer();
        eventMeshProducer.init(this.eventMeshHTTPServer.getEventMeshHttpConfiguration(), producerGroupConfig);
        this.producerTable.put(producerGroupConfig.getGroupName(), eventMeshProducer);
        return eventMeshProducer;
    }

    public void shutdown() {
        for (EventMeshProducer eventMeshProducer : this.producerTable.values()) {
            try {
                eventMeshProducer.shutdown();
            }
            catch (Exception ex) {
                this.logger.error("shutdown eventMeshProducer[{}] err", (Object)eventMeshProducer, (Object)ex);
            }
        }
        this.logger.info("producerManager shutdown......");
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public ConcurrentHashMap<String, EventMeshProducer> getProducerTable() {
        return this.producerTable;
    }
}

