/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumer.ClientInfo;
import org.apache.eventmesh.runtime.core.consumer.SubscriptionManager;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.WebhookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor
implements HttpRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribeProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public SubscribeProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        final HttpCommand request = asyncContext.getRequest();
        Integer requestCode = Integer.valueOf(asyncContext.getRequest().getRequestCode());
        String localAddress = IPUtils.getLocalAddress();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)requestCode), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        }
        SubscribeRequestHeader subscribeRequestHeader = (SubscribeRequestHeader)request.getHeader();
        SubscribeRequestBody subscribeRequestBody = (SubscribeRequestBody)request.getBody();
        SubscribeResponseHeader subscribeResponseHeader = SubscribeResponseHeader.buildHeader((Integer)requestCode, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster(), (String)localAddress, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        if (StringUtils.isBlank((CharSequence)subscribeRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)subscribeRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)subscribeRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)subscribeRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = request.createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)subscribeRequestBody.getUrl()) || CollectionUtils.isEmpty((Collection)subscribeRequestBody.getTopics()) || StringUtils.isBlank((CharSequence)subscribeRequestBody.getConsumerGroup())) {
            HttpCommand responseEventMeshCommand = request.createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        List subTopicList = subscribeRequestBody.getTopics();
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
            for (SubscriptionItem item : subTopicList) {
                try {
                    Acl.doAclCheckInHttpReceive(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), subscribeRequestHeader.getUsername(), subscribeRequestHeader.getPasswd(), subscribeRequestHeader.getSys(), item.getTopic(), requestCode);
                }
                catch (Exception e) {
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                    asyncContext.onComplete(responseEventMeshCommand);
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("CLIENT HAS NO PERMISSION,SubscribeProcessor subscribe failed", (Throwable)e);
                    }
                    return;
                }
            }
        }
        String url = subscribeRequestBody.getUrl();
        String consumerGroup = subscribeRequestBody.getConsumerGroup();
        try {
            if (!IPUtils.isValidDomainOrIp((String)url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIpv4BlackList, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIpv6BlackList)) {
                LOGGER.error("subscriber url {} is not valid", (Object)url);
                HttpCommand responseEventMeshCommand = request.createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " invalid URL: " + url)));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("subscriber url:{} is invalid.", (Object)url, (Object)e);
            }
            HttpCommand responseEventMeshCommand = request.createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " invalid URL: " + url)));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (!WebhookUtil.obtainDeliveryAgreement(this.eventMeshHTTPServer.httpClientPool.getClient(), url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshWebhookOrigin())) {
            LOGGER.error("subscriber url {} is not allowed by the target system", (Object)url);
            HttpCommand responseEventMeshCommand = request.createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " unauthorized webhook URL: " + url)));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            ClientInfo clientInfo = this.getClientInfo(subscribeRequestHeader);
            SubscriptionManager subscriptionManager = this.eventMeshHTTPServer.getSubscriptionManager();
            subscriptionManager.registerClient(clientInfo, consumerGroup, subTopicList, url);
            subscriptionManager.updateSubscription(clientInfo, consumerGroup, url, subTopicList);
            long startTime = System.currentTimeMillis();
            try {
                this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().get(consumerGroup));
                CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

                    @Override
                    public void onResponse(HttpCommand httpCommand) {
                        try {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("{}", (Object)httpCommand);
                            }
                            SubscribeProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                            SubscribeProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                        }
                        catch (Exception ex) {
                            LOGGER.error("onResponse error", (Throwable)ex);
                        }
                    }
                };
                HttpCommand responseEventMeshCommand = request.createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                asyncContext.onComplete(responseEventMeshCommand, handler);
            }
            catch (Exception e) {
                HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                asyncContext.onComplete(err);
                long endTime = System.currentTimeMillis();
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)subscribeRequestBody.getTopics()), subscribeRequestBody.getUrl(), e});
                }
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgFailed();
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgCost(endTime - startTime);
            }
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    private ClientInfo getClientInfo(SubscribeRequestHeader subscribeRequestHeader) {
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setEnv(subscribeRequestHeader.getEnv());
        clientInfo.setIdc(subscribeRequestHeader.getIdc());
        clientInfo.setSys(subscribeRequestHeader.getSys());
        clientInfo.setIp(subscribeRequestHeader.getIp());
        clientInfo.setPid(subscribeRequestHeader.getPid());
        return clientInfo;
    }
}

