/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.ReplyMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.ReplyMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.ReplyMessageResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyMessageProcessor
implements HttpRequestProcessor {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public ReplyMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        String content;
        String localAddress = IPUtils.getLocalAddress();
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        ReplyMessageRequestHeader replyMessageRequestHeader = (ReplyMessageRequestHeader)asyncContext.getRequest().getHeader();
        String protocolType = replyMessageRequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)asyncContext.getRequest());
        final ReplyMessageResponseHeader replyMessageResponseHeader = ReplyMessageResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster(), (String)localAddress, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        if (event == null || StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String idc = Objects.requireNonNull(event.getExtension("idc")).toString();
        String pid = Objects.requireNonNull(event.getExtension("pid")).toString();
        String sys = Objects.requireNonNull(event.getExtension("sys")).toString();
        if (StringUtils.isBlank((CharSequence)idc) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        final String bizNo = Objects.requireNonNull(event.getExtension("bizseqno")).toString();
        final String uniqueId = Objects.requireNonNull(event.getExtension("uniqueid")).toString();
        String producerGroup = Objects.requireNonNull(event.getExtension("producergroup")).toString();
        if (StringUtils.isBlank((CharSequence)bizNo) || StringUtils.isBlank((CharSequence)uniqueId) || StringUtils.isBlank((CharSequence)producerGroup) || event.getData() == null) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getErrMsg()));
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPDiscard();
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String string = content = event.getData() == null ? "" : new String(event.getData().toBytes(), StandardCharsets.UTF_8);
        if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
            this.httpLogger.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)("Event size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize)));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        final long startTime = System.currentTimeMillis();
        String replyTopic = "rr-reply-topic";
        final String origTopic = event.getSubject();
        final String replyMQCluster = Optional.ofNullable(event.getExtension("cluster")).map(Objects::toString).orElse("");
        if (StringUtils.isEmpty((CharSequence)replyMQCluster)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        replyTopic = replyMQCluster + "-" + replyTopic;
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withSubject(replyTopic).withExtension("msgtype", "persistent").withExtension("timeout", String.valueOf(3000)).withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
            if (this.messageLogger.isDebugEnabled()) {
                this.messageLogger.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)replyTopic);
            }
        }
        catch (Exception e) {
            this.messageLogger.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, replyTopic, e});
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
        this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordReplyMsg();
        final CompleteHandler<HttpCommand> handler = httpCommand -> {
            try {
                if (this.httpLogger.isDebugEnabled()) {
                    this.httpLogger.debug("{}", httpCommand);
                }
                this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        try {
            CloudEvent clone = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            sendMessageContext.setEvent(clone);
            eventMeshProducer.reply(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    HttpCommand succ = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
                    asyncContext.onComplete(succ, handler);
                    long endTime = System.currentTimeMillis();
                    ReplyMessageProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordReplyMsgCost(endTime - startTime);
                    ReplyMessageProcessor.this.messageLogger.info("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyMQCluster + "-" + "rr-reply-topic", origTopic, bizNo, uniqueId});
                }

                public void onException(OnExceptionContext context) {
                    HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2))));
                    asyncContext.onComplete(err, handler);
                    long endTime = System.currentTimeMillis();
                    ReplyMessageProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordReplyMsgFailed();
                    ReplyMessageProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordReplyMsgCost(endTime - startTime);
                    ReplyMessageProcessor.this.messageLogger.error("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyMQCluster + "-" + "rr-reply-topic", origTopic, bizNo, uniqueId, context.getException()});
                }
            });
        }
        catch (Exception ex) {
            HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
            asyncContext.onComplete(err);
            long endTime = System.currentTimeMillis();
            this.messageLogger.error("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, origTopic, bizNo, uniqueId, ex});
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordReplyMsgFailed();
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordReplyMsgCost(endTime - startTime);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

