/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace(isEnable=false)
public class LocalUnSubscribeEventProcessor
extends AbstractEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(LocalUnSubscribeEventProcessor.class);

    public LocalUnSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        String localAddress = IPUtils.getLocalAddress();
        if (log.isInfoEnabled()) {
            log.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        }
        requestWrapper.getHeaderMap().put("ip", RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
        requestWrapper.buildSysHeaderForClient();
        Map<String, Object> responseHeaderMap = this.builderResponseHeaderMap(requestWrapper);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        if (this.validateSysHeader(sysHeaderMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = Optional.ofNullable(JsonUtils.deserialize((String)new String(requestBody, Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<HashMap<String, Object>>(){})).orElseGet(Maps::newHashMap);
        if (this.validatedRequestBodyMap(requestBodyMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String unSubscribeUrl = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        List unSubTopicList = Optional.ofNullable(JsonUtils.deserialize((String)JsonUtils.serialize(requestBodyMap.get("topic")), (TypeReference)new TypeReference<List<String>>(){})).orElseGet(Collections::emptyList);
        String pid = sysHeaderMap.get("pid").toString();
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            boolean isChange = true;
            this.registerClient(requestWrapper, consumerGroup, unSubTopicList, unSubscribeUrl);
            for (String unSubTopic : unSubTopicList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().get(consumerGroup + "@" + unSubTopic);
                Iterator<Client> clientIterator = groupTopicClients.iterator();
                while (clientIterator.hasNext()) {
                    Client client = clientIterator.next();
                    if (!StringUtils.equals((CharSequence)client.getPid(), (CharSequence)pid) || !StringUtils.equals((CharSequence)client.getUrl(), (CharSequence)unSubscribeUrl)) continue;
                    if (log.isWarnEnabled()) {
                        log.warn("client {} start unsubscribe", (Object)JsonUtils.serialize((Object)client));
                    }
                    clientIterator.remove();
                }
                if (CollectionUtils.isNotEmpty(groupTopicClients)) {
                    HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                    HashSet<String> clientUrls = new HashSet<String>();
                    for (Client client : groupTopicClients) {
                        if (StringUtils.equals((CharSequence)unSubscribeUrl, (CharSequence)client.getUrl())) continue;
                        clientUrls.add(client.getUrl());
                        ArrayList<String> urls = (ArrayList<String>)idcUrls.get(client.getIdc());
                        if (urls == null) {
                            urls = new ArrayList<String>();
                            idcUrls.put(client.getIdc(), urls);
                        }
                        urls.add(StringUtils.deleteWhitespace((String)client.getUrl()));
                    }
                    ConcurrentHashMap<String, ConsumerGroupConf> concurrentHashMap2 = this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping();
                    synchronized (concurrentHashMap2) {
                        ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().get(consumerGroup);
                        Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                        for (Map.Entry<String, ConsumerGroupTopicConf> entry : map.entrySet()) {
                            if (!StringUtils.equals((CharSequence)unSubTopic, (CharSequence)entry.getKey())) continue;
                            ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                            latestTopicConf.setConsumerGroup(consumerGroup);
                            latestTopicConf.setTopic(unSubTopic);
                            latestTopicConf.setSubscriptionItem(entry.getValue().getSubscriptionItem());
                            latestTopicConf.setUrls(clientUrls);
                            latestTopicConf.setIdcUrls(idcUrls);
                            map.put(unSubTopic, latestTopicConf);
                        }
                        this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().put(consumerGroup, consumerGroupConf);
                        continue;
                    }
                }
                isChange = false;
                break;
            }
            long startTime = System.currentTimeMillis();
            if (isChange) {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().get(consumerGroup));
                    responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                    responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                    handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{System.currentTimeMillis() - startTime, JsonUtils.serialize((Object)unSubTopicList), unSubscribeUrl, e});
                    }
                    handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
                }
            } else {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, null);
                    responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                    responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                    handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
                    this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().keySet().removeIf(s -> StringUtils.contains((CharSequence)s, (CharSequence)consumerGroup));
                    this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().keySet().removeIf(s -> StringUtils.equals((CharSequence)consumerGroup, (CharSequence)s));
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{System.currentTimeMillis() - startTime, JsonUtils.serialize((Object)unSubTopicList), unSubscribeUrl, e});
                    }
                    handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
                }
            }
            this.updateMetadata();
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.UNSUBSCRIBE_LOCAL.getRequestURI()};
    }

    private void registerClient(HttpEventWrapper requestWrapper, String consumerGroup, List<String> topicList, String url) {
        Objects.requireNonNull(requestWrapper, "requestWrapper can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(topicList, "topicList can not be null");
        Objects.requireNonNull(url, "url can not be null");
        Map requestHeaderMap = requestWrapper.getSysHeaderMap();
        for (String topic : topicList) {
            Client client = new Client();
            client.setEnv(requestHeaderMap.get("env").toString());
            client.setIdc(requestHeaderMap.get("idc").toString());
            client.setSys(requestHeaderMap.get("sys").toString());
            client.setIp(requestHeaderMap.get("ip").toString());
            client.setPid(requestHeaderMap.get("pid").toString());
            client.setConsumerGroup(consumerGroup);
            client.setTopic(topic);
            client.setUrl(url);
            client.setLastUpTime(new Date());
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            List<Client> localClients = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().get(groupTopicKey);
            if (localClients == null) {
                localClients = new ArrayList<Client>();
                this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().put(groupTopicKey, localClients);
            }
            boolean isContains = false;
            for (Client localClient : localClients) {
                if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)client.getUrl())) continue;
                isContains = true;
                localClient.setLastUpTime(client.getLastUpTime());
                break;
            }
            if (isContains) continue;
            localClients.add(client);
        }
    }
}

