/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.producer;

import io.cloudevents.CloudEvent;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageContext
extends RetryContext {
    public static final Logger logger = LoggerFactory.getLogger((String)"retry");
    private CloudEvent event;
    private String bizSeqNo;
    private EventMeshProducer eventMeshProducer;
    private long createTime = System.currentTimeMillis();
    public EventMeshGrpcServer eventMeshGrpcServer;

    public SendMessageContext(String bizSeqNo, CloudEvent event, EventMeshProducer eventMeshProducer, EventMeshGrpcServer eventMeshGrpcServer) {
        this.bizSeqNo = bizSeqNo;
        this.event = event;
        this.eventMeshProducer = eventMeshProducer;
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public CloudEvent getEvent() {
        return this.event;
    }

    public void setEvent(CloudEvent event) {
        this.event = event;
    }

    public EventMeshProducer getEventMeshProducer() {
        return this.eventMeshProducer;
    }

    public void setEventMeshProducer(EventMeshProducer eventMeshProducer) {
        this.eventMeshProducer = eventMeshProducer;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageContext={").append("bizSeqNo=").append(this.bizSeqNo).append(",retryTimes=").append(this.retryTimes).append(",producer=").append(this.eventMeshProducer != null ? this.eventMeshProducer : null).append(",executeTime=").append(DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    @Override
    public boolean retry() throws Exception {
        if (this.eventMeshProducer == null) {
            return false;
        }
        if (this.retryTimes > 0) {
            return false;
        }
        ++this.retryTimes;
        this.eventMeshProducer.send(this, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                logger.warn("", (Throwable)context.getException());
            }
        });
        return true;
    }
}

