/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.tcp.codec.Codec;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpConnectionHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpExceptionHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpMessageDispatcher;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventMeshRebalanceService;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventmeshRebalanceImpl;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry.EventMeshTcpRetryer;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMonitor;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.eventmesh.runtime.util.EventMeshThreadFactoryImpl;
import org.apache.eventmesh.webhook.admin.AdminWebHookConfigOperationManage;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTCPServer
extends AbstractRemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventMeshTCPServer.class);
    private ClientSessionGroupMapping clientSessionGroupMapping;
    private transient EventMeshTcpRetryer eventMeshTcpRetryer;
    private transient EventMeshTcpMonitor eventMeshTcpMonitor;
    private final transient EventMeshServer eventMeshServer;
    private final transient EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private transient GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private transient ScheduledExecutorService scheduler;
    private transient ExecutorService taskHandleExecutorService;
    private transient ExecutorService broadcastMsgDownstreamExecutorService;
    private final transient Registry registry;
    private transient EventMeshRebalanceService eventMeshRebalanceService;
    private transient AdminWebHookConfigOperationManage adminWebHookConfigOperationManage;
    private transient RateLimiter rateLimiter;

    public void setClientSessionGroupMapping(ClientSessionGroupMapping clientSessionGroupMapping) {
        this.clientSessionGroupMapping = clientSessionGroupMapping;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public ExecutorService getTaskHandleExecutorService() {
        return this.taskHandleExecutorService;
    }

    public ExecutorService getBroadcastMsgDownstreamExecutorService() {
        return this.broadcastMsgDownstreamExecutorService;
    }

    public void setTaskHandleExecutorService(ExecutorService taskHandleExecutorService) {
        this.taskHandleExecutorService = taskHandleExecutorService;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public EventMeshTCPServer(EventMeshServer eventMeshServer, EventMeshTCPConfiguration eventMeshTCPConfiguration, Registry registry) {
        this.eventMeshServer = eventMeshServer;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.registry = registry;
    }

    private void startServer() {
        Runnable r = () -> {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ChannelInitializer channelInitializer = new ChannelInitializer(){

                public void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new Codec.Encoder()}).addLast(new ChannelHandler[]{new Codec.Decoder()}).addLast("global-traffic-shaping", (ChannelHandler)EventMeshTCPServer.this.globalTrafficShapingHandler).addLast("channel-traffic-shaping", (ChannelHandler)EventMeshTCPServer.this.newCTSHandler(EventMeshTCPServer.this.eventMeshTCPConfiguration.getCtc().getReadLimit())).addLast(new ChannelHandler[]{new EventMeshTcpConnectionHandler(EventMeshTCPServer.this)}).addLast((EventExecutorGroup)EventMeshTCPServer.this.getWorkerGroup(), new ChannelHandler[]{new IdleStateHandler(((EventMeshTCPServer)EventMeshTCPServer.this).eventMeshTCPConfiguration.eventMeshTcpIdleReadSeconds, ((EventMeshTCPServer)EventMeshTCPServer.this).eventMeshTCPConfiguration.eventMeshTcpIdleWriteSeconds, ((EventMeshTCPServer)EventMeshTCPServer.this).eventMeshTCPConfiguration.eventMeshTcpIdleAllSeconds), new EventMeshTcpMessageDispatcher(EventMeshTCPServer.this), new EventMeshTcpExceptionHandler(EventMeshTCPServer.this)});
                }
            };
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.getBossGroup(), this.getIoGroup()).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.SO_LINGER, (Object)0).childOption(ChannelOption.SO_TIMEOUT, (Object)600000).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)262140).childOption(ChannelOption.SO_RCVBUF, (Object)262140).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(2048, 4096, 65536))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)channelInitializer);
            try {
                int port = this.eventMeshTCPConfiguration.eventMeshTcpServerPort;
                ChannelFuture f = bootstrap.bind(port).sync();
                LOGGER.info("EventMeshTCPServer[port={}] started.....", (Object)port);
                f.channel().closeFuture().sync();
            }
            catch (Exception e) {
                LOGGER.error("EventMeshTCPServer RemotingServer Start Err!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception ex) {
                    LOGGER.error("EventMeshTCPServer RemotingServer shutdown Err!", (Throwable)ex);
                }
            }
        };
        Thread t = new Thread(r, "eventMesh-tcp-server");
        t.start();
    }

    public void init() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("==================EventMeshTCPServer Initialing==================");
        }
        this.initThreadPool();
        this.rateLimiter = RateLimiter.create((double)this.eventMeshTCPConfiguration.eventMeshTcpMsgReqnumPerSecond.intValue());
        this.globalTrafficShapingHandler = this.newGTSHandler(this.scheduler, this.eventMeshTCPConfiguration.getGtc().getReadLimit());
        this.adminWebHookConfigOperationManage = new AdminWebHookConfigOperationManage();
        this.adminWebHookConfigOperationManage.setConfigurationWrapper(this.eventMeshTCPConfiguration.getConfigurationWrapper());
        this.adminWebHookConfigOperationManage.init();
        this.clientSessionGroupMapping = new ClientSessionGroupMapping(this);
        this.clientSessionGroupMapping.init();
        this.eventMeshTcpRetryer = new EventMeshTcpRetryer(this);
        this.eventMeshTcpRetryer.init();
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshTCPConfiguration.getEventMeshMetricsPluginType()).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.eventMeshTcpMonitor = new EventMeshTcpMonitor(this, metricsRegistries);
        this.eventMeshTcpMonitor.init();
        if (this.eventMeshTCPConfiguration.isEventMeshServerRegistryEnable()) {
            this.eventMeshRebalanceService = new EventMeshRebalanceService(this, new EventmeshRebalanceImpl(this));
            this.eventMeshRebalanceService.init();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("--------------------------EventMeshTCPServer Inited");
        }
    }

    @Override
    public void start() throws Exception {
        this.startServer();
        this.clientSessionGroupMapping.start();
        this.eventMeshTcpRetryer.start();
        this.eventMeshTcpMonitor.start();
        if (this.eventMeshTCPConfiguration.isEventMeshServerRegistryEnable()) {
            this.register();
            this.eventMeshRebalanceService.start();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("--------------------------EventMeshTCPServer Started");
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.getBossGroup() != null) {
            this.getBossGroup().shutdownGracefully();
            LOGGER.info("shutdown bossGroup, no client is allowed to connect access server");
        }
        if (this.eventMeshTCPConfiguration.isEventMeshServerRegistryEnable()) {
            this.eventMeshRebalanceService.shutdown();
            this.unRegister();
        }
        this.clientSessionGroupMapping.shutdown();
        try {
            Thread.sleep(40000L);
        }
        catch (InterruptedException e) {
            LOGGER.error("interruptedException occurred while sleeping", (Throwable)e);
        }
        this.globalTrafficShapingHandler.release();
        if (this.getIoGroup() != null) {
            this.getIoGroup().shutdownGracefully();
            LOGGER.info("shutdown ioGroup");
        }
        if (this.getWorkerGroup() != null) {
            this.getWorkerGroup().shutdownGracefully();
            LOGGER.info("shutdown workerGroup");
        }
        this.eventMeshTcpRetryer.shutdown();
        this.eventMeshTcpMonitor.shutdown();
        this.shutdownThreadPool();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("--------------------------EventMeshTCPServer Shutdown");
        }
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshTCPConfiguration.eventMeshTcpServerPort;
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshTCPConfiguration.getEventMeshCluster());
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshTCPConfiguration.getEventMeshName() + "-" + "TCP");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setEventMeshInstanceNumMap(this.clientSessionGroupMapping.prepareProxyClientDistributionData());
            eventMeshRegisterInfo.setProtocolType("TCP");
            registerResult = this.registry.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            LOGGER.error("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() throws Exception {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshTCPConfiguration.eventMeshTcpServerPort;
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshTCPConfiguration.getEventMeshCluster());
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshTCPConfiguration.getEventMeshName());
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("TCP");
        boolean registerResult = this.registry.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    private void initThreadPool() throws Exception {
        super.init("eventMesh-tcp");
        this.scheduler = ThreadPoolFactory.createScheduledExecutor((int)this.eventMeshTCPConfiguration.eventMeshTcpGlobalScheduler, (ThreadFactory)new EventMeshThreadFactoryImpl("eventMesh-tcp-scheduler", true));
        this.taskHandleExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.eventMeshTcpTaskHandleExecutorPoolSize, (int)this.eventMeshTCPConfiguration.eventMeshTcpTaskHandleExecutorPoolSize, new LinkedBlockingQueue(10000), (ThreadFactory)new EventMeshThreadFactoryImpl("eventMesh-tcp-task-handle", true));
        this.broadcastMsgDownstreamExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.eventMeshTcpMsgDownStreamExecutorPoolSize, (int)this.eventMeshTCPConfiguration.eventMeshTcpMsgDownStreamExecutorPoolSize, new LinkedBlockingQueue(10000), (ThreadFactory)new EventMeshThreadFactoryImpl("eventMesh-tcp-msg-downstream", true));
    }

    private void shutdownThreadPool() {
        this.scheduler.shutdown();
        this.taskHandleExecutorService.shutdown();
    }

    private GlobalTrafficShapingHandler newGTSHandler(ScheduledExecutorService executor, long readLimit) {
        GlobalTrafficShapingHandler handler = new GlobalTrafficShapingHandler(executor, 0L, readLimit){

            protected long calculateSize(Object msg) {
                return 1L;
            }
        };
        handler.setMaxTimeWait(1000L);
        return handler;
    }

    private ChannelTrafficShapingHandler newCTSHandler(long readLimit) {
        ChannelTrafficShapingHandler handler = new ChannelTrafficShapingHandler(0L, readLimit){

            protected long calculateSize(Object msg) {
                return 1L;
            }
        };
        handler.setMaxTimeWait(3000L);
        return handler;
    }

    public ClientSessionGroupMapping getClientSessionGroupMapping() {
        return this.clientSessionGroupMapping;
    }

    public EventMeshTcpRetryer getEventMeshTcpRetryer() {
        return this.eventMeshTcpRetryer;
    }

    public EventMeshTcpMonitor getEventMeshTcpMonitor() {
        return this.eventMeshTcpMonitor;
    }

    public EventMeshServer getEventMeshServer() {
        return this.eventMeshServer;
    }

    public EventMeshTCPConfiguration getEventMeshTCPConfiguration() {
        return this.eventMeshTCPConfiguration;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public EventMeshRebalanceService getEventMeshRebalanceService() {
        return this.eventMeshRebalanceService;
    }

    public AdminWebHookConfigOperationManage getAdminWebHookConfigOperationManage() {
        return this.adminWebHookConfigOperationManage;
    }

    public void setAdminWebHookConfigOperationManage(AdminWebHookConfigOperationManage adminWebHookConfigOperationManage) {
        this.adminWebHookConfigOperationManage = adminWebHookConfigOperationManage;
    }
}

