/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.util.concurrent.RateLimiter;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.GrpcRetryer;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ConsumerService;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.HeartbeatService;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ProducerService;
import org.apache.eventmesh.runtime.metrics.grpc.EventMeshGrpcMonitor;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private static final int MIN_LIMIT = 5;
    private static final int MAX_LIMIT = 10;
    private Server server;
    private ProducerManager producerManager;
    private ConsumerManager consumerManager;
    private GrpcRetryer grpcRetryer;
    private ThreadPoolExecutor sendMsgExecutor;
    private ThreadPoolExecutor replyMsgExecutor;
    private ThreadPoolExecutor clientMgmtExecutor;
    private ThreadPoolExecutor pushMsgExecutor;
    private List<CloseableHttpClient> httpClientPool;
    private RateLimiter msgRateLimiter;
    private Registry registry;
    private EventMeshGrpcMonitor eventMeshGrpcMonitor;

    public EventMeshGrpcServer(EventMeshGrpcConfiguration eventMeshGrpcConfiguration, Registry registry) {
        this.eventMeshGrpcConfiguration = eventMeshGrpcConfiguration;
        this.registry = registry;
    }

    public void init() throws Exception {
        this.logger.info("==================EventMeshGRPCServer Initializing==================");
        this.initThreadPool();
        this.initHttpClientPool();
        this.msgRateLimiter = RateLimiter.create((double)this.eventMeshGrpcConfiguration.eventMeshMsgReqNumPerSecond);
        this.producerManager = new ProducerManager(this);
        this.producerManager.init();
        this.consumerManager = new ConsumerManager(this);
        this.consumerManager.init();
        this.grpcRetryer = new GrpcRetryer(this);
        this.grpcRetryer.init();
        int serverPort = this.eventMeshGrpcConfiguration.grpcServerPort;
        this.server = ServerBuilder.forPort((int)serverPort).addService((BindableService)new ProducerService(this, this.sendMsgExecutor)).addService((BindableService)new ConsumerService(this, this.clientMgmtExecutor, this.replyMsgExecutor)).addService((BindableService)new HeartbeatService(this, this.clientMgmtExecutor)).build();
        this.initMetricsMonitor();
        this.logger.info("GRPCServer[port={}] started", (Object)serverPort);
        this.logger.info("-----------------EventMeshGRPCServer initialized");
    }

    public void start() throws Exception {
        this.logger.info("---------------EventMeshGRPCServer starting-------------------");
        this.producerManager.start();
        this.consumerManager.start();
        this.grpcRetryer.start();
        this.server.start();
        if (this.eventMeshGrpcConfiguration.isEventMeshServerRegistryEnable()) {
            this.register();
        }
        this.eventMeshGrpcMonitor.start();
        this.logger.info("---------------EventMeshGRPCServer running-------------------");
    }

    public void shutdown() throws Exception {
        this.logger.info("---------------EventMeshGRPCServer stopping-------------------");
        this.producerManager.shutdown();
        this.consumerManager.shutdown();
        this.grpcRetryer.shutdown();
        this.shutdownThreadPools();
        this.shutdownHttpClientPool();
        this.server.shutdown();
        if (this.eventMeshGrpcConfiguration.isEventMeshServerRegistryEnable()) {
            this.unRegister();
        }
        this.eventMeshGrpcMonitor.shutdown();
        this.logger.info("---------------EventMeshGRPCServer stopped-------------------");
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshGrpcConfiguration.grpcServerPort;
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshGrpcConfiguration.getEventMeshCluster());
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshGrpcConfiguration.getEventMeshName() + "-" + "GRPC");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setProtocolType("GRPC");
            registerResult = this.registry.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            this.logger.warn("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() throws Exception {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshGrpcConfiguration.grpcServerPort;
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshGrpcConfiguration.getEventMeshCluster());
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshGrpcConfiguration.getEventMeshName());
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("GRPC");
        boolean registerResult = this.registry.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    public EventMeshGrpcConfiguration getEventMeshGrpcConfiguration() {
        return this.eventMeshGrpcConfiguration;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public GrpcRetryer getGrpcRetryer() {
        return this.grpcRetryer;
    }

    public ThreadPoolExecutor getSendMsgExecutor() {
        return this.sendMsgExecutor;
    }

    public ThreadPoolExecutor getClientMgmtExecutor() {
        return this.clientMgmtExecutor;
    }

    public ThreadPoolExecutor getPushMsgExecutor() {
        return this.pushMsgExecutor;
    }

    public RateLimiter getMsgRateLimiter() {
        return this.msgRateLimiter;
    }

    public CloseableHttpClient getHttpClient() {
        int size = this.httpClientPool.size();
        return this.httpClientPool.get(RandomUtils.nextInt((int)size, (int)(2 * size)) % size);
    }

    public EventMeshGrpcMonitor getMetricsMonitor() {
        return this.eventMeshGrpcMonitor;
    }

    private void initThreadPool() {
        LinkedBlockingQueue sendMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerSendMsgBlockQueueSize);
        this.sendMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerSendMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerSendMsgThreadNum, sendMsgThreadPoolQueue, (String)"eventMesh-grpc-sendMsg-%d", (boolean)true);
        LinkedBlockingQueue subscribeMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerSubscribeMsgBlockQueueSize);
        this.clientMgmtExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerSubscribeMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerSubscribeMsgThreadNum, subscribeMsgThreadPoolQueue, (String)"eventMesh-grpc-clientMgmt-%d", (boolean)true);
        LinkedBlockingQueue pushMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerPushMsgBlockQueueSize);
        this.pushMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerPushMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerPushMsgThreadNum, pushMsgThreadPoolQueue, (String)"eventMesh-grpc-pushMsg-%d", (boolean)true);
        this.replyMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerReplyMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerReplyMsgThreadNum, sendMsgThreadPoolQueue, (String)"eventMesh-grpc-replyMsg-%d", (boolean)true);
    }

    private void initHttpClientPool() {
        this.httpClientPool = new LinkedList<CloseableHttpClient>();
        int clientPool = RandomUtils.nextInt((int)5, (int)10);
        for (int i = 0; i < clientPool; ++i) {
            CloseableHttpClient client = HttpClients.createDefault();
            this.httpClientPool.add(client);
        }
    }

    private void initMetricsMonitor() throws Exception {
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshGrpcConfiguration.getEventMeshMetricsPluginType()).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.eventMeshGrpcMonitor = new EventMeshGrpcMonitor(this, metricsRegistries);
        this.eventMeshGrpcMonitor.init();
    }

    private void shutdownThreadPools() {
        this.sendMsgExecutor.shutdown();
        this.clientMgmtExecutor.shutdown();
        this.pushMsgExecutor.shutdown();
        this.replyMsgExecutor.shutdown();
    }

    private void shutdownHttpClientPool() {
        Iterator<CloseableHttpClient> itr = this.httpClientPool.iterator();
        while (itr.hasNext()) {
            CloseableHttpClient client = itr.next();
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            itr.remove();
        }
    }
}

