/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/showClient")
public class ShowClientHandler
extends AbstractHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShowClientHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowClientHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        StringBuilder result = new StringBuilder();
        try (OutputStream out = httpExchange.getResponseBody();){
            String newLine = System.getProperty("line.separator");
            logger.info("showAllClient=================");
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            HashMap<String, AtomicInteger> statMap = new HashMap<String, AtomicInteger>();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            if (!sessionMap.isEmpty()) {
                for (Session session : sessionMap.values()) {
                    String key = session.getClient().getSubsystem();
                    if (!statMap.containsKey(key)) {
                        statMap.put(key, new AtomicInteger(1));
                        continue;
                    }
                    ((AtomicInteger)statMap.get(key)).incrementAndGet();
                }
                for (Map.Entry entry : statMap.entrySet()) {
                    result.append(String.format("System=%s | ClientNum=%d", entry.getKey(), ((AtomicInteger)entry.getValue()).intValue())).append(newLine);
                }
            }
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.toString().getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            logger.error("ShowClientHandler fail...", (Throwable)e);
        }
    }
}

