/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/rejectClientByIpPort")
public class RejectClientByIpPortHandler
extends AbstractHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(RejectClientByIpPortHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public RejectClientByIpPortHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        try (OutputStream out = httpExchange.getResponseBody();){
            String queryString = httpExchange.getRequestURI().getQuery();
            Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
            String ip = (String)queryStringInfo.get("ip");
            String port = (String)queryStringInfo.get("port");
            if (StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)port)) {
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                result = "params illegal!";
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                return;
            }
            logger.info("rejectClientByIpPort in admin,ip:{},port:{}====================", (Object)ip, (Object)port);
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
            try {
                if (!sessionMap.isEmpty()) {
                    for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                        InetSocketAddress addr;
                        if (!entry.getKey().getHostString().equals(ip) || !String.valueOf(entry.getKey().getPort()).equals(port) || (addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer, entry.getValue(), clientSessionGroupMapping)) == null) continue;
                        successRemoteAddrs.add(addr);
                    }
                }
            }
            catch (Exception e) {
                logger.error("clientManage|rejectClientByIpPort|fail|ip={}|port={},errMsg={}", new Object[]{ip, port, e});
                result = String.format("rejectClientByIpPort fail! {ip=%s port=%s}, had reject {%s}, errorMsg : %s", ip, port, NetUtils.addressToString(successRemoteAddrs), e.getMessage());
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                if (out != null) {
                    if (var4_5 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                return;
            }
            result = String.format("rejectClientByIpPort success! {ip=%s port=%s}, had reject {%s}", ip, port, NetUtils.addressToString(successRemoteAddrs));
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            logger.error("rejectClientByIpPort fail...", (Throwable)e);
        }
    }
}

