/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/webhook/queryWebHookConfigByManufacturer")
public class QueryWebHookConfigByManufacturerHandler
extends AbstractHttpHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(QueryWebHookConfigByManufacturerHandler.class);
    private final transient WebHookConfigOperation operation;

    public QueryWebHookConfigByManufacturerHandler(WebHookConfigOperation operation, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.operation = operation;
        Objects.requireNonNull(operation, "WebHookConfigOperation can not be null");
        Objects.requireNonNull(httpHandlerManager, "HttpHandlerManager can not be null");
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Objects.requireNonNull(httpExchange, "httpExchange can not be null");
        NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        JsonNode node = JsonUtils.getJsonNode((String)NetUtils.parsePostBody((HttpExchange)httpExchange));
        Objects.requireNonNull(node, "JsonNode can not be null");
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.deserialize((String)node.get("webHookConfig").toString(), WebHookConfig.class);
        Integer pageNum = Integer.valueOf(node.get("pageNum").toString());
        Integer pageSize = Integer.valueOf(node.get("pageSize").toString());
        try (OutputStream out = httpExchange.getResponseBody();){
            List result = this.operation.queryWebHookConfigByManufacturer(webHookConfig, pageNum, pageSize);
            out.write(JsonUtils.serialize((Object)result).getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            LOGGER.error("get WebHookConfigOperation implementation Failed.", (Throwable)e);
        }
    }
}

