/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/webhook/queryWebHookConfigById")
public class QueryWebHookConfigByIdHandler
extends AbstractHttpHandler {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private final WebHookConfigOperation operation;

    public QueryWebHookConfigByIdHandler(WebHookConfigOperation operation, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.operation = operation;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        String requestBody = NetUtils.parsePostBody((HttpExchange)httpExchange);
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.deserialize((String)requestBody, WebHookConfig.class);
        try (OutputStream out = httpExchange.getResponseBody();){
            WebHookConfig result = this.operation.queryWebHookConfigById(webHookConfig);
            out.write(JsonUtils.serialize((Object)result).getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            this.logger.error("get WebHookConfigOperation implementation Failed.", (Throwable)e);
        }
    }
}

