/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.Attributes;
import io.grpc.ExperimentalApi;
import io.grpc.Internal;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerStreamTracer;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.ServerListener;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SharedResourcePool;
import io.grpc.internal.TransportTracer;
import io.grpc.netty.EmptyServerListenerDelegator;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServer;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.ServerListenerDelegator;
import io.grpc.netty.Utils;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.ServerChannel;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
@CanIgnoreReturnValue
public final class PinpointNettyServerBuilder
extends AbstractServerImplBuilder<PinpointNettyServerBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    static final long MAX_CONNECTION_IDLE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_GRACE_NANOS_INFINITE = Long.MAX_VALUE;
    private static final long MIN_KEEPALIVE_TIME_NANO = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long MIN_KEEPALIVE_TIMEOUT_NANO = TimeUnit.MICROSECONDS.toNanos(499L);
    private static final long MIN_MAX_CONNECTION_IDLE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long MIN_MAX_CONNECTION_AGE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource((SharedResourceHolder.Resource)Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP);
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource((SharedResourceHolder.Resource)Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
    private final ServerImplBuilder serverImplBuilder;
    private final List<SocketAddress> listenAddresses = new ArrayList<SocketAddress>();
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private ChannelFactory<? extends ServerChannel> channelFactory = Utils.DEFAULT_SERVER_CHANNEL_FACTORY;
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private final Map<ChannelOption<?>, Object> childChannelOptions = new HashMap();
    private ObjectPool<? extends EventLoopGroup> bossEventLoopGroupPool = DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL;
    private ObjectPool<? extends EventLoopGroup> workerEventLoopGroupPool = DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
    private boolean forceHeapBuffer;
    private ProtocolNegotiator.ServerFactory protocolNegotiatorFactory;
    private final boolean freezeProtocolNegotiatorFactory;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private boolean autoFlowControl = true;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeInNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIME_NANOS;
    private long keepAliveTimeoutInNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS;
    private long maxConnectionIdleInNanos = Long.MAX_VALUE;
    private long maxConnectionAgeInNanos = Long.MAX_VALUE;
    private long maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
    private boolean permitKeepAliveWithoutCalls;
    private long permitKeepAliveTimeInNanos = TimeUnit.MINUTES.toNanos(5L);
    private Attributes eagAttributes = Attributes.EMPTY;
    private ServerListenerDelegator serverListenerDelegator = new EmptyServerListenerDelegator();

    @CheckReturnValue
    public static PinpointNettyServerBuilder forPort(int port) {
        return PinpointNettyServerBuilder.forAddress(new InetSocketAddress(port));
    }

    @CheckReturnValue
    public static PinpointNettyServerBuilder forPort(int port, ServerCredentials creds) {
        return PinpointNettyServerBuilder.forAddress(new InetSocketAddress(port), creds);
    }

    @CheckReturnValue
    public static PinpointNettyServerBuilder forAddress(SocketAddress address) {
        return new PinpointNettyServerBuilder(address);
    }

    @CheckReturnValue
    public static PinpointNettyServerBuilder forAddress(SocketAddress address, ServerCredentials creds) {
        ProtocolNegotiators.FromServerCredentialsResult result = ProtocolNegotiators.from((ServerCredentials)creds);
        if (result.error != null) {
            throw new IllegalArgumentException(result.error);
        }
        return new PinpointNettyServerBuilder(address, result.negotiator);
    }

    @CheckReturnValue
    private PinpointNettyServerBuilder(SocketAddress address) {
        this.serverImplBuilder = new ServerImplBuilder((ServerImplBuilder.ClientTransportServersBuilder)new NettyClientTransportServersBuilder());
        this.listenAddresses.add(address);
        this.protocolNegotiatorFactory = ProtocolNegotiators.serverPlaintextFactory();
        this.freezeProtocolNegotiatorFactory = false;
    }

    @CheckReturnValue
    PinpointNettyServerBuilder(SocketAddress address, ProtocolNegotiator.ServerFactory negotiatorFactory) {
        this.serverImplBuilder = new ServerImplBuilder((ServerImplBuilder.ClientTransportServersBuilder)new NettyClientTransportServersBuilder());
        this.listenAddresses.add(address);
        this.protocolNegotiatorFactory = (ProtocolNegotiator.ServerFactory)Preconditions.checkNotNull((Object)negotiatorFactory, (Object)"negotiatorFactory");
        this.freezeProtocolNegotiatorFactory = true;
    }

    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public PinpointNettyServerBuilder addListenAddress(SocketAddress listenAddress) {
        this.listenAddresses.add((SocketAddress)Preconditions.checkNotNull((Object)listenAddress, (Object)"listenAddress"));
        return this;
    }

    public PinpointNettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        Preconditions.checkNotNull(channelType, (Object)"channelType");
        return this.channelFactory((ChannelFactory<? extends ServerChannel>)new ReflectiveChannelFactory(channelType));
    }

    public PinpointNettyServerBuilder channelFactory(ChannelFactory<? extends ServerChannel> channelFactory) {
        this.channelFactory = (ChannelFactory)Preconditions.checkNotNull(channelFactory, (Object)"channelFactory");
        return this;
    }

    public <T> PinpointNettyServerBuilder withOption(ChannelOption<T> option, T value) {
        this.channelOptions.put(option, value);
        return this;
    }

    public <T> PinpointNettyServerBuilder withChildOption(ChannelOption<T> option, T value) {
        this.childChannelOptions.put(option, value);
        return this;
    }

    public PinpointNettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        if (group != null) {
            return this.bossEventLoopGroupPool((ObjectPool<? extends EventLoopGroup>)new FixedObjectPool((Object)group));
        }
        return this.bossEventLoopGroupPool(DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL);
    }

    PinpointNettyServerBuilder bossEventLoopGroupPool(ObjectPool<? extends EventLoopGroup> bossEventLoopGroupPool) {
        this.bossEventLoopGroupPool = (ObjectPool)Preconditions.checkNotNull(bossEventLoopGroupPool, (Object)"bossEventLoopGroupPool");
        return this;
    }

    public PinpointNettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        if (group != null) {
            return this.workerEventLoopGroupPool((ObjectPool<? extends EventLoopGroup>)new FixedObjectPool((Object)group));
        }
        return this.workerEventLoopGroupPool(DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL);
    }

    PinpointNettyServerBuilder workerEventLoopGroupPool(ObjectPool<? extends EventLoopGroup> workerEventLoopGroupPool) {
        this.workerEventLoopGroupPool = (ObjectPool)Preconditions.checkNotNull(workerEventLoopGroupPool, (Object)"workerEventLoopGroupPool");
        return this;
    }

    void setForceHeapBuffer(boolean value) {
        this.forceHeapBuffer = value;
    }

    public PinpointNettyServerBuilder sslContext(SslContext sslContext) {
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ServerCredentials");
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isServer(), (Object)"Client SSL context can not be used for server");
            GrpcSslContexts.ensureAlpnAndH2Enabled((ApplicationProtocolNegotiator)sslContext.applicationProtocolNegotiator());
            this.protocolNegotiatorFactory = ProtocolNegotiators.serverTlsFactory((SslContext)sslContext);
        } else {
            this.protocolNegotiatorFactory = ProtocolNegotiators.serverPlaintextFactory();
        }
        return this;
    }

    @Internal
    public final PinpointNettyServerBuilder protocolNegotiator(ProtocolNegotiator protocolNegotiator) {
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ServerCredentials");
        this.protocolNegotiatorFactory = ProtocolNegotiators.fixedServerFactory((ProtocolNegotiator)protocolNegotiator);
        return this;
    }

    public void setTracingEnabled(boolean value) {
        this.serverImplBuilder.setTracingEnabled(value);
    }

    public void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }

    public void setStatsRecordStartedRpcs(boolean value) {
        this.serverImplBuilder.setStatsRecordStartedRpcs(value);
    }

    public void setStatsRecordRealTimeMetrics(boolean value) {
        this.serverImplBuilder.setStatsRecordRealTimeMetrics(value);
    }

    public PinpointNettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument((maxCalls > 0 ? 1 : 0) != 0, (String)"max must be positive: %s", (int)maxCalls);
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public PinpointNettyServerBuilder initialFlowControlWindow(int initialFlowControlWindow) {
        Preconditions.checkArgument((initialFlowControlWindow > 0 ? 1 : 0) != 0, (Object)"initialFlowControlWindow must be positive");
        this.flowControlWindow = initialFlowControlWindow;
        this.autoFlowControl = true;
        return this;
    }

    public PinpointNettyServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (String)"flowControlWindow must be positive: %s", (int)flowControlWindow);
        this.flowControlWindow = flowControlWindow;
        this.autoFlowControl = false;
        return this;
    }

    @Deprecated
    public PinpointNettyServerBuilder maxMessageSize(int maxMessageSize) {
        return this.maxInboundMessageSize(maxMessageSize);
    }

    public PinpointNettyServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (String)"bytes must be non-negative: %s", (int)bytes);
        this.maxMessageSize = bytes;
        return this;
    }

    @Deprecated
    public PinpointNettyServerBuilder maxHeaderListSize(int maxHeaderListSize) {
        return this.maxInboundMetadataSize(maxHeaderListSize);
    }

    public PinpointNettyServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (String)"maxInboundMetadataSize must be positive: %s", (int)bytes);
        this.maxHeaderListSize = bytes;
        return this;
    }

    public PinpointNettyServerBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime > 0L ? 1 : 0) != 0, (String)"keepalive time must be positive\uff1a%s", (long)keepAliveTime);
        this.keepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeInNanos = KeepAliveManager.clampKeepAliveTimeInNanos((long)this.keepAliveTimeInNanos);
        if (this.keepAliveTimeInNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeInNanos = Long.MAX_VALUE;
        }
        if (this.keepAliveTimeInNanos < MIN_KEEPALIVE_TIME_NANO) {
            this.keepAliveTimeInNanos = MIN_KEEPALIVE_TIME_NANO;
        }
        return this;
    }

    public PinpointNettyServerBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTimeout > 0L ? 1 : 0) != 0, (String)"keepalive timeout must be positive: %s", (long)keepAliveTimeout);
        this.keepAliveTimeoutInNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutInNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos((long)this.keepAliveTimeoutInNanos);
        if (this.keepAliveTimeoutInNanos < MIN_KEEPALIVE_TIMEOUT_NANO) {
            this.keepAliveTimeoutInNanos = MIN_KEEPALIVE_TIMEOUT_NANO;
        }
        return this;
    }

    public PinpointNettyServerBuilder maxConnectionIdle(long maxConnectionIdle, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionIdle > 0L ? 1 : 0) != 0, (String)"max connection idle must be positive: %s", (long)maxConnectionIdle);
        this.maxConnectionIdleInNanos = timeUnit.toNanos(maxConnectionIdle);
        if (this.maxConnectionIdleInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionIdleInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionIdleInNanos < MIN_MAX_CONNECTION_IDLE_NANO) {
            this.maxConnectionIdleInNanos = MIN_MAX_CONNECTION_IDLE_NANO;
        }
        return this;
    }

    public PinpointNettyServerBuilder maxConnectionAge(long maxConnectionAge, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionAge > 0L ? 1 : 0) != 0, (String)"max connection age must be positive: %s", (long)maxConnectionAge);
        this.maxConnectionAgeInNanos = timeUnit.toNanos(maxConnectionAge);
        if (this.maxConnectionAgeInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionAgeInNanos < MIN_MAX_CONNECTION_AGE_NANO) {
            this.maxConnectionAgeInNanos = MIN_MAX_CONNECTION_AGE_NANO;
        }
        return this;
    }

    public PinpointNettyServerBuilder maxConnectionAgeGrace(long maxConnectionAgeGrace, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionAgeGrace >= 0L ? 1 : 0) != 0, (String)"max connection age grace must be non-negative: %s", (long)maxConnectionAgeGrace);
        this.maxConnectionAgeGraceInNanos = timeUnit.toNanos(maxConnectionAgeGrace);
        if (this.maxConnectionAgeGraceInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
        }
        return this;
    }

    public PinpointNettyServerBuilder permitKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime >= 0L ? 1 : 0) != 0, (String)"permit keepalive time must be non-negative: %s", (long)keepAliveTime);
        this.permitKeepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        return this;
    }

    public PinpointNettyServerBuilder permitKeepAliveWithoutCalls(boolean permit) {
        this.permitKeepAliveWithoutCalls = permit;
        return this;
    }

    void eagAttributes(Attributes eagAttributes) {
        this.eagAttributes = (Attributes)Preconditions.checkNotNull((Object)eagAttributes, (Object)"eagAttributes");
    }

    public void serverListenerDelegator(ServerListenerDelegator serverListenerDelegator) {
        this.serverListenerDelegator = Objects.requireNonNull(serverListenerDelegator, "serverListenerDelegator");
    }

    @CheckReturnValue
    NettyServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        this.assertEventLoopsAndChannelType();
        ProtocolNegotiator negotiator = this.protocolNegotiatorFactory.newNegotiator(this.serverImplBuilder.getExecutorPool());
        NettyServer transportServer = new NettyServer(this.listenAddresses, this.channelFactory, this.channelOptions, this.childChannelOptions, this.bossEventLoopGroupPool, this.workerEventLoopGroupPool, this.forceHeapBuffer, negotiator, streamTracerFactories, this.transportTracerFactory, this.maxConcurrentCallsPerConnection, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, this.maxConnectionIdleInNanos, this.maxConnectionAgeInNanos, this.maxConnectionAgeGraceInNanos, this.permitKeepAliveWithoutCalls, this.permitKeepAliveTimeInNanos, this.eagAttributes, this.serverImplBuilder.getChannelz()){

            public void start(ServerListener serverListener) throws IOException {
                ServerListener delegate = PinpointNettyServerBuilder.this.serverListenerDelegator.wrapServerListener(serverListener);
                super.start(delegate);
            }
        };
        return transportServer;
    }

    @VisibleForTesting
    void assertEventLoopsAndChannelType() {
        boolean allProvided = this.channelFactory != Utils.DEFAULT_SERVER_CHANNEL_FACTORY && this.bossEventLoopGroupPool != DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL && this.workerEventLoopGroupPool != DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
        boolean nonProvided = this.channelFactory == Utils.DEFAULT_SERVER_CHANNEL_FACTORY && this.bossEventLoopGroupPool == DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL && this.workerEventLoopGroupPool == DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
        Preconditions.checkState((allProvided || nonProvided ? 1 : 0) != 0, (Object)"All of BossEventLoopGroup, WorkerEventLoopGroup and ChannelType should be provided or neither should be");
    }

    PinpointNettyServerBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public PinpointNettyServerBuilder useTransportSecurity(File certChain, File privateKey) {
        SslContext sslContext;
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ServerCredentials");
        try {
            sslContext = GrpcSslContexts.forServer((File)certChain, (File)privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        this.protocolNegotiatorFactory = ProtocolNegotiators.serverTlsFactory((SslContext)sslContext);
        return this;
    }

    public PinpointNettyServerBuilder useTransportSecurity(InputStream certChain, InputStream privateKey) {
        SslContext sslContext;
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ServerCredentials");
        try {
            sslContext = GrpcSslContexts.forServer((InputStream)certChain, (InputStream)privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        this.protocolNegotiatorFactory = ProtocolNegotiators.serverTlsFactory((SslContext)sslContext);
        return this;
    }

    private final class NettyClientTransportServersBuilder
    implements ServerImplBuilder.ClientTransportServersBuilder {
        private NettyClientTransportServersBuilder() {
        }

        public InternalServer buildClientTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
            return PinpointNettyServerBuilder.this.buildTransportServers(streamTracerFactories);
        }
    }
}

