/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body.message;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;

public class SendMessageResponseBody
extends Body {
    private Integer retCode;
    private String retMsg;
    private long resTime = System.currentTimeMillis();

    public Integer getRetCode() {
        return this.retCode;
    }

    public void setRetCode(Integer retCode) {
        this.retCode = retCode;
    }

    public String getRetMsg() {
        return this.retMsg;
    }

    public void setRetMsg(String retMsg) {
        this.retMsg = retMsg;
    }

    public long getResTime() {
        return this.resTime;
    }

    public void setResTime(long resTime) {
        this.resTime = resTime;
    }

    public static SendMessageResponseBody buildBody(Integer retCode, String retMsg) {
        SendMessageResponseBody sendMessageResponseBody = new SendMessageResponseBody();
        sendMessageResponseBody.setRetMsg(retMsg);
        sendMessageResponseBody.setResTime(System.currentTimeMillis());
        sendMessageResponseBody.setRetCode(retCode);
        return sendMessageResponseBody;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageResponseBody={").append("retCode=").append(this.retCode).append(",").append("retMsg=").append(this.retMsg).append(",").append("resTime=").append(DateFormatUtils.format((long)this.resTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("retCode", this.retCode);
        map.put("retMsg", this.retMsg);
        map.put("resTime", this.resTime);
        return map;
    }

    public static class ReplyMessage {
        public String topic;
        public String body;
        public Map<String, String> properties;

        ReplyMessage(String topic, String body, Map<String, String> properties) {
            this.topic = topic;
            this.body = body;
            this.properties = properties;
        }

        public static ReplyMessageBuilder builder() {
            return new ReplyMessageBuilder();
        }

        public String getTopic() {
            return this.topic;
        }

        public String getBody() {
            return this.body;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplyMessage)) {
                return false;
            }
            ReplyMessage other = (ReplyMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplyMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "SendMessageResponseBody.ReplyMessage(topic=" + this.getTopic() + ", body=" + this.getBody() + ", properties=" + this.getProperties() + ")";
        }

        public static class ReplyMessageBuilder {
            private String topic;
            private String body;
            private Map<String, String> properties;

            ReplyMessageBuilder() {
            }

            public ReplyMessageBuilder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public ReplyMessageBuilder body(String body) {
                this.body = body;
                return this;
            }

            public ReplyMessageBuilder properties(Map<String, String> properties) {
                this.properties = properties;
                return this;
            }

            public ReplyMessage build() {
                return new ReplyMessage(this.topic, this.body, this.properties);
            }

            public String toString() {
                return "SendMessageResponseBody.ReplyMessage.ReplyMessageBuilder(topic=" + this.topic + ", body=" + this.body + ", properties=" + this.properties + ")";
            }
        }
    }
}

