/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.tcp.codec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.RedirectInfo;
import org.apache.eventmesh.common.protocol.tcp.Subscription;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Codec {
    private static final Logger LOG = LoggerFactory.getLogger(Codec.class);
    private static final int FRAME_MAX_LENGTH = 0x400000;
    private static final byte[] CONSTANT_MAGIC_FLAG = Codec.serializeBytes("EventMesh");
    private static final byte[] VERSION = Codec.serializeBytes("0000");
    public static final String CLOUD_EVENTS_PROTOCOL_NAME = "cloudevents";
    public static final String EM_MESSAGE_PROTOCOL_NAME = "eventmeshmessage";
    public static final String OPEN_MESSAGE_PROTOCOL_NAME = "openmessage";
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private static Object deserializeBody(String bodyJsonString, Header header) throws JsonProcessingException {
        Command command = header.getCmd();
        switch (command) {
            case HELLO_REQUEST: 
            case RECOMMEND_REQUEST: {
                return OBJECT_MAPPER.readValue(bodyJsonString, UserAgent.class);
            }
            case SUBSCRIBE_REQUEST: 
            case UNSUBSCRIBE_REQUEST: {
                return OBJECT_MAPPER.readValue(bodyJsonString, Subscription.class);
            }
            case REQUEST_TO_SERVER: 
            case RESPONSE_TO_SERVER: 
            case ASYNC_MESSAGE_TO_SERVER: 
            case BROADCAST_MESSAGE_TO_SERVER: 
            case REQUEST_TO_CLIENT: 
            case RESPONSE_TO_CLIENT: 
            case ASYNC_MESSAGE_TO_CLIENT: 
            case BROADCAST_MESSAGE_TO_CLIENT: 
            case REQUEST_TO_CLIENT_ACK: 
            case RESPONSE_TO_CLIENT_ACK: 
            case ASYNC_MESSAGE_TO_CLIENT_ACK: 
            case BROADCAST_MESSAGE_TO_CLIENT_ACK: {
                return bodyJsonString;
            }
            case REDIRECT_TO_CLIENT: {
                return OBJECT_MAPPER.readValue(bodyJsonString, RedirectInfo.class);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("Invalidate TCP command: {}", (Object)command);
        }
        return null;
    }

    private static String deserializeBytes(byte[] bytes) {
        return new String(bytes, Constants.DEFAULT_CHARSET);
    }

    private static byte[] serializeBytes(String str) {
        if (str == null) {
            return new byte[0];
        }
        return str.getBytes(Constants.DEFAULT_CHARSET);
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        OBJECT_MAPPER.setTimeZone(TimeZone.getDefault());
    }

    public static class Decoder
    extends ReplayingDecoder<Package> {
        public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            try {
                if (null == in) {
                    return;
                }
                byte[] flagBytes = this.parseFlag(in);
                byte[] versionBytes = this.parseVersion(in);
                this.validateFlag(flagBytes, versionBytes, ctx);
                int length = in.readInt();
                int headerLength = in.readInt();
                int bodyLength = length - 8 - headerLength;
                Header header = this.parseHeader(in, headerLength);
                Object body = this.parseBody(in, header, bodyLength);
                Package pkg = new Package(header, body);
                out.add(pkg);
            }
            catch (Exception e) {
                LOG.error(String.format("decode error| receive: %s.", Codec.deserializeBytes(in.array())), (Throwable)e);
                throw e;
            }
        }

        private byte[] parseFlag(ByteBuf in) {
            byte[] flagBytes = new byte[CONSTANT_MAGIC_FLAG.length];
            in.readBytes(flagBytes);
            return flagBytes;
        }

        private byte[] parseVersion(ByteBuf in) {
            byte[] versionBytes = new byte[VERSION.length];
            in.readBytes(versionBytes);
            return versionBytes;
        }

        private Header parseHeader(ByteBuf in, int headerLength) throws JsonProcessingException {
            if (headerLength <= 0) {
                return null;
            }
            byte[] headerData = new byte[headerLength];
            in.readBytes(headerData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decode headerJson={}", (Object)Codec.deserializeBytes(headerData));
            }
            return (Header)OBJECT_MAPPER.readValue(Codec.deserializeBytes(headerData), Header.class);
        }

        private Object parseBody(ByteBuf in, Header header, int bodyLength) throws JsonProcessingException {
            if (bodyLength <= 0 || header == null) {
                return null;
            }
            byte[] bodyData = new byte[bodyLength];
            in.readBytes(bodyData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decode bodyJson={}", (Object)Codec.deserializeBytes(bodyData));
            }
            return Codec.deserializeBody(Codec.deserializeBytes(bodyData), header);
        }

        private void validateFlag(byte[] flagBytes, byte[] versionBytes, ChannelHandlerContext ctx) {
            if (!Arrays.equals(flagBytes, CONSTANT_MAGIC_FLAG) || !Arrays.equals(versionBytes, VERSION)) {
                String errorMsg = String.format("invalid magic flag or version|flag=%s|version=%s|remoteAddress=%s", Codec.deserializeBytes(flagBytes), Codec.deserializeBytes(versionBytes), ctx.channel().remoteAddress());
                throw new IllegalArgumentException(errorMsg);
            }
        }
    }

    public static class Encoder
    extends MessageToByteEncoder<Package> {
        public void encode(ChannelHandlerContext ctx, Package pkg, ByteBuf out) throws Exception {
            int bodyLength;
            Preconditions.checkNotNull((Object)pkg, (Object)"TcpPackage cannot be null");
            Header header = pkg.getHeader();
            Preconditions.checkNotNull((Object)header, (String)"TcpPackage header cannot be null", (Object)header);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encoder pkg={}", (Object)JsonUtils.serialize(pkg));
            }
            byte[] headerData = Codec.serializeBytes(OBJECT_MAPPER.writeValueAsString((Object)header));
            byte[] bodyData = StringUtils.equals((CharSequence)Codec.CLOUD_EVENTS_PROTOCOL_NAME, (CharSequence)header.getStringProperty("protocoltype")) ? (byte[])pkg.getBody() : Codec.serializeBytes(OBJECT_MAPPER.writeValueAsString(pkg.getBody()));
            int headerLength = ArrayUtils.getLength((Object)headerData);
            int length = 8 + headerLength + (bodyLength = ArrayUtils.getLength((Object)bodyData));
            if (length > 0x400000) {
                throw new IllegalArgumentException("message size is exceed limit!");
            }
            out.writeBytes(CONSTANT_MAGIC_FLAG);
            out.writeBytes(VERSION);
            out.writeInt(length);
            out.writeInt(headerLength);
            if (headerData != null) {
                out.writeBytes(headerData);
            }
            if (bodyData != null) {
                out.writeBytes(bodyData);
            }
        }
    }
}

