/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.client;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.nio.charset.StandardCharsets;
import org.apache.eventmesh.connector.pravega.client.PravegaEvent;

public class PravegaCloudEventWriter
implements MessageWriter<CloudEventWriter<PravegaEvent>, PravegaEvent>,
CloudEventWriter<PravegaEvent> {
    private final PravegaEvent pravegaEvent = new PravegaEvent();

    public PravegaCloudEventWriter(String topic) {
        this.pravegaEvent.setTopic(topic);
        this.pravegaEvent.setCreateTimestamp(System.currentTimeMillis());
    }

    public PravegaEvent setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.pravegaEvent.setData(new String(value, StandardCharsets.UTF_8));
        return this.pravegaEvent;
    }

    public PravegaEvent end(CloudEventData data) throws CloudEventRWException {
        this.pravegaEvent.setData(new String(data.toBytes(), StandardCharsets.UTF_8));
        return this.pravegaEvent;
    }

    public PravegaEvent end() throws CloudEventRWException {
        this.pravegaEvent.setData("");
        return this.pravegaEvent;
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        this.pravegaEvent.getExtensions().put(name, value);
        return this;
    }

    public CloudEventWriter<PravegaEvent> create(SpecVersion version) throws CloudEventRWException {
        this.pravegaEvent.setVersion(version);
        return this;
    }
}

