/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis.supervisor;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.name.Named;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskClientFactory;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisor;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorIOConfig;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorIngestionSpec;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorTuningConfig;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIngestionSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.metrics.DruidMonitorSchedulerConfig;

public class KinesisSupervisorSpec
extends SeekableStreamSupervisorSpec {
    private static final String SUPERVISOR_TYPE = "kinesis";
    private final AWSCredentialsConfig awsCredentialsConfig;

    @JsonCreator
    public KinesisSupervisorSpec(@JsonProperty(value="spec") @Nullable KinesisSupervisorIngestionSpec ingestionSchema, @JsonProperty(value="dataSchema") @Nullable DataSchema dataSchema, @JsonProperty(value="tuningConfig") @Nullable KinesisSupervisorTuningConfig tuningConfig, @JsonProperty(value="ioConfig") @Nullable KinesisSupervisorIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="suspended") Boolean suspended, @JacksonInject TaskStorage taskStorage, @JacksonInject TaskMaster taskMaster, @JacksonInject IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, @JacksonInject KinesisIndexTaskClientFactory kinesisIndexTaskClientFactory, @JacksonInject @Json ObjectMapper mapper, @JacksonInject ServiceEmitter emitter, @JacksonInject DruidMonitorSchedulerConfig monitorSchedulerConfig, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject @Named(value="kinesis") AWSCredentialsConfig awsCredentialsConfig, @JacksonInject SupervisorStateManagerConfig supervisorStateManagerConfig) {
        super((SeekableStreamSupervisorIngestionSpec)(ingestionSchema != null ? ingestionSchema : new KinesisSupervisorIngestionSpec(dataSchema, ioConfig, tuningConfig != null ? tuningConfig : KinesisSupervisorTuningConfig.defaultConfig())), context, suspended, taskStorage, taskMaster, indexerMetadataStorageCoordinator, (SeekableStreamIndexTaskClientFactory)kinesisIndexTaskClientFactory, mapper, emitter, monitorSchedulerConfig, rowIngestionMetersFactory, supervisorStateManagerConfig);
        this.awsCredentialsConfig = awsCredentialsConfig;
    }

    public Supervisor createSupervisor() {
        return new KinesisSupervisor(this.taskStorage, this.taskMaster, this.indexerMetadataStorageCoordinator, (KinesisIndexTaskClientFactory)this.indexTaskClientFactory, this.mapper, this, this.rowIngestionMetersFactory, this.awsCredentialsConfig);
    }

    public String getType() {
        return SUPERVISOR_TYPE;
    }

    public String getSource() {
        return this.getIoConfig() != null ? this.getIoConfig().getStream() : null;
    }

    public String toString() {
        return "KinesisSupervisorSpec{dataSchema=" + this.getDataSchema() + ", tuningConfig=" + (Object)((Object)this.getTuningConfig()) + ", ioConfig=" + (Object)((Object)this.getIoConfig()) + ", suspended=" + this.isSuspended() + ", context=" + this.getContext() + '}';
    }

    @Deprecated
    @JsonProperty
    public KinesisSupervisorTuningConfig getTuningConfig() {
        return (KinesisSupervisorTuningConfig)super.getTuningConfig();
    }

    @Deprecated
    @JsonProperty
    public KinesisSupervisorIOConfig getIoConfig() {
        return (KinesisSupervisorIOConfig)super.getIoConfig();
    }

    @JsonProperty
    public KinesisSupervisorIngestionSpec getSpec() {
        return (KinesisSupervisorIngestionSpec)super.getSpec();
    }

    protected KinesisSupervisorSpec toggleSuspend(boolean suspend) {
        return new KinesisSupervisorSpec(this.getSpec(), this.getDataSchema(), this.getTuningConfig(), this.getIoConfig(), this.getContext(), suspend, this.taskStorage, this.taskMaster, this.indexerMetadataStorageCoordinator, (KinesisIndexTaskClientFactory)this.indexTaskClientFactory, this.mapper, this.emitter, this.monitorSchedulerConfig, this.rowIngestionMetersFactory, this.awsCredentialsConfig, this.supervisorStateManagerConfig);
    }
}

