/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis.supervisor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.indexing.kinesis.KinesisRegion;
import org.apache.druid.indexing.seekablestream.supervisor.IdleConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class KinesisSupervisorIOConfig
extends SeekableStreamSupervisorIOConfig {
    private final String endpoint;
    private final Integer recordsPerFetch;
    private final Integer fetchDelayMillis;
    private final String awsAssumedRoleArn;
    private final String awsExternalId;
    private final boolean deaggregate;

    @JsonCreator
    public KinesisSupervisorIOConfig(@JsonProperty(value="stream") String stream, @JsonProperty(value="inputFormat") InputFormat inputFormat, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="region") KinesisRegion region, @JsonProperty(value="replicas") Integer replicas, @JsonProperty(value="taskCount") Integer taskCount, @JsonProperty(value="taskDuration") Period taskDuration, @JsonProperty(value="startDelay") Period startDelay, @JsonProperty(value="period") Period period, @JsonProperty(value="useEarliestSequenceNumber") Boolean useEarliestSequenceNumber, @JsonProperty(value="completionTimeout") Period completionTimeout, @JsonProperty(value="lateMessageRejectionPeriod") Period lateMessageRejectionPeriod, @JsonProperty(value="earlyMessageRejectionPeriod") Period earlyMessageRejectionPeriod, @JsonProperty(value="lateMessageRejectionStartDateTime") DateTime lateMessageRejectionStartDateTime, @JsonProperty(value="recordsPerFetch") Integer recordsPerFetch, @JsonProperty(value="fetchDelayMillis") Integer fetchDelayMillis, @JsonProperty(value="awsAssumedRoleArn") String awsAssumedRoleArn, @JsonProperty(value="awsExternalId") String awsExternalId, @Nullable @JsonProperty(value="autoScalerConfig") AutoScalerConfig autoScalerConfig, @JsonProperty(value="deaggregate") boolean deaggregate) {
        super((String)Preconditions.checkNotNull((Object)stream, (Object)"stream"), inputFormat, replicas, taskCount, taskDuration, startDelay, period, useEarliestSequenceNumber, completionTimeout, lateMessageRejectionPeriod, earlyMessageRejectionPeriod, autoScalerConfig, lateMessageRejectionStartDateTime, new IdleConfig(null, null));
        this.endpoint = endpoint != null ? endpoint : (region != null ? region.getEndpoint() : KinesisRegion.US_EAST_1.getEndpoint());
        this.recordsPerFetch = recordsPerFetch != null ? recordsPerFetch : 4000;
        this.fetchDelayMillis = fetchDelayMillis != null ? fetchDelayMillis : 0;
        this.awsAssumedRoleArn = awsAssumedRoleArn;
        this.awsExternalId = awsExternalId;
        this.deaggregate = deaggregate;
    }

    @JsonProperty
    public String getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty
    public Integer getRecordsPerFetch() {
        return this.recordsPerFetch;
    }

    @JsonProperty
    public Integer getFetchDelayMillis() {
        return this.fetchDelayMillis;
    }

    @JsonProperty
    public String getAwsAssumedRoleArn() {
        return this.awsAssumedRoleArn;
    }

    @JsonProperty
    public String getAwsExternalId() {
        return this.awsExternalId;
    }

    @JsonProperty
    public boolean isDeaggregate() {
        return this.deaggregate;
    }

    public String toString() {
        return "KinesisSupervisorIOConfig{stream='" + this.getStream() + '\'' + ", endpoint='" + this.endpoint + '\'' + ", replicas=" + this.getReplicas() + ", taskCount=" + this.getTaskCount() + ", autoScalerConfig=" + this.getAutoScalerConfig() + ", taskDuration=" + this.getTaskDuration() + ", startDelay=" + this.getStartDelay() + ", period=" + this.getPeriod() + ", useEarliestSequenceNumber=" + this.isUseEarliestSequenceNumber() + ", completionTimeout=" + this.getCompletionTimeout() + ", lateMessageRejectionPeriod=" + this.getLateMessageRejectionPeriod() + ", earlyMessageRejectionPeriod=" + this.getEarlyMessageRejectionPeriod() + ", lateMessageRejectionStartDateTime=" + this.getLateMessageRejectionStartDateTime() + ", recordsPerFetch=" + this.recordsPerFetch + ", fetchDelayMillis=" + this.fetchDelayMillis + ", awsAssumedRoleArn='" + this.awsAssumedRoleArn + '\'' + ", awsExternalId='" + this.awsExternalId + '\'' + ", deaggregate=" + this.deaggregate + '}';
    }
}

