/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class NestedFieldVirtualColumn
implements VirtualColumn {
    private final String columnName;
    private final String outputName;
    @Nullable
    private final ColumnType expectedType;
    private final List<NestedPathPart> parts;
    private final boolean processFromRaw;
    private final boolean hasNegativeArrayIndex;

    @JsonCreator
    public NestedFieldVirtualColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="expectedType") @Nullable ColumnType expectedType, @JsonProperty(value="pathParts") @Nullable List<NestedPathPart> parts, @JsonProperty(value="processFromRaw") @Nullable Boolean processFromRaw, @JsonProperty(value="path") @Nullable String path, @JsonProperty(value="useJqSyntax") @Nullable Boolean useJqSyntax) {
        this.columnName = columnName;
        this.outputName = outputName;
        if (path != null) {
            Preconditions.checkArgument((parts == null ? 1 : 0) != 0, (Object)"Cannot define both 'path' and 'pathParts'");
        } else if (parts == null) {
            throw new IllegalArgumentException("Must define exactly one of 'path' or 'pathParts'");
        }
        if (parts != null) {
            this.parts = parts;
        } else {
            boolean isInputJq = useJqSyntax != null && useJqSyntax != false;
            this.parts = isInputJq ? NestedPathFinder.parseJqPath(path) : NestedPathFinder.parseJsonPath(path);
        }
        boolean hasNegative = false;
        for (NestedPathPart part : this.parts) {
            NestedPathArrayElement elementPart;
            if (!(part instanceof NestedPathArrayElement) || (elementPart = (NestedPathArrayElement)part).getIndex() >= 0) continue;
            hasNegative = true;
            break;
        }
        this.hasNegativeArrayIndex = hasNegative;
        this.expectedType = expectedType;
        this.processFromRaw = processFromRaw == null ? false : processFromRaw;
    }

    @VisibleForTesting
    public NestedFieldVirtualColumn(String columnName, String path, String outputName) {
        this(columnName, outputName, null, null, null, path, false);
    }

    @VisibleForTesting
    public NestedFieldVirtualColumn(String columnName, String path, String outputName, ColumnType expectedType) {
        this(columnName, outputName, expectedType, null, null, path, false);
    }

    public byte[] getCacheKey() {
        String partsString = NestedPathFinder.toNormalizedJsonPath(this.parts);
        return new CacheKeyBuilder(-1).appendString("nested-field").appendString(this.outputName).appendString(this.columnName).appendString(partsString).appendBoolean(this.processFromRaw).build();
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="pathParts")
    public List<NestedPathPart> getPathParts() {
        return this.parts;
    }

    @JsonProperty
    public ColumnType getExpectedType() {
        return this.expectedType;
    }

    @JsonProperty
    public boolean isProcessFromRaw() {
        return this.processFromRaw;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        ColumnValueSelector<?> valueSelector = this.makeColumnValueSelector(dimensionSpec.getOutputName(), factory);
        return new FieldDimensionSelector(valueSelector);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        ColumnValueSelector baseSelector = factory.makeColumnValueSelector(this.columnName);
        return this.processFromRaw ? new RawFieldColumnSelector(baseSelector, this.parts) : new RawFieldLiteralColumnValueSelector(baseSelector, this.parts);
    }

    @Override
    @Nullable
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableOffset offset) {
        NestedDataComplexColumn column = NestedDataComplexColumn.fromColumnSelector(columnSelector, this.columnName);
        if (column == null) {
            return DimensionSelector.constant(null);
        }
        if (this.hasNegativeArrayIndex) {
            return new FieldDimensionSelector(new RawFieldLiteralColumnValueSelector(column.makeColumnValueSelector(offset), this.parts));
        }
        return column.makeDimensionSelector(this.parts, offset, dimensionSpec.getExtractionFn());
    }

    @Override
    @Nullable
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelector columnSelector, ReadableOffset offset) {
        NestedDataComplexColumn column = NestedDataComplexColumn.fromColumnSelector(columnSelector, this.columnName);
        if (column == null) {
            return NilColumnValueSelector.instance();
        }
        return this.processFromRaw ? new RawFieldColumnSelector(column.makeColumnValueSelector(offset), this.parts) : (this.hasNegativeArrayIndex ? new RawFieldLiteralColumnValueSelector(column.makeColumnValueSelector(offset), this.parts) : column.makeColumnValueSelector(this.parts, offset));
    }

    @Override
    public boolean canVectorize(ColumnInspector inspector) {
        return !this.hasNegativeArrayIndex;
    }

    @Override
    @Nullable
    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        NestedDataComplexColumn column = NestedDataComplexColumn.fromColumnSelector(columnSelector, this.columnName);
        if (column == null) {
            return NilVectorSelector.create(offset);
        }
        return column.makeSingleValueDimensionVectorSelector(this.parts, offset);
    }

    @Override
    @Nullable
    public VectorObjectSelector makeVectorObjectSelector(String columnName, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        NestedDataComplexColumn column = NestedDataComplexColumn.fromColumnSelector(columnSelector, this.columnName);
        if (column == null) {
            return NilVectorSelector.create(offset);
        }
        return this.processFromRaw ? new RawFieldVectorObjectSelector(column.makeVectorObjectSelector(offset), this.parts) : column.makeVectorObjectSelector(this.parts, offset);
    }

    @Override
    @Nullable
    public VectorValueSelector makeVectorValueSelector(String columnName, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        NestedDataComplexColumn column = NestedDataComplexColumn.fromColumnSelector(columnSelector, this.columnName);
        if (column == null) {
            return NilVectorSelector.create(offset);
        }
        if (column.isNumeric(this.parts) || this.expectedType == null) {
            return column.makeVectorValueSelector(this.parts, offset);
        }
        final VectorObjectSelector objectSelector = column.makeVectorObjectSelector(this.parts, offset);
        if (this.expectedType.is((TypeDescriptor)ValueType.LONG)) {
            return new BaseLongVectorValueSelector(offset){
                private final long[] longVector;
                @Nullable
                private boolean[] nullVector;
                private int id;
                {
                    super(offset);
                    this.longVector = new long[this.offset.getMaxVectorSize()];
                    this.nullVector = null;
                    this.id = -1;
                }

                @Override
                public long[] getLongVector() {
                    this.computeVectorsIfNeeded();
                    return this.longVector;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    this.id = this.offset.getId();
                    Object[] vals = objectSelector.getObjectVector();
                    for (int i = 0; i < objectSelector.getCurrentVectorSize(); ++i) {
                        Object v = vals[i];
                        if (v == null) {
                            if (this.nullVector == null) {
                                this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                            }
                            this.longVector[i] = 0L;
                            this.nullVector[i] = true;
                            continue;
                        }
                        Long l = v instanceof Number ? Long.valueOf(((Number)v).longValue()) : GuavaUtils.tryParseLong((String)String.valueOf(v));
                        if (l != null) {
                            this.longVector[i] = l;
                            if (this.nullVector == null) continue;
                            this.nullVector[i] = false;
                            continue;
                        }
                        if (this.nullVector == null) {
                            this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                        }
                        this.longVector[i] = 0L;
                        this.nullVector[i] = true;
                    }
                }
            };
        }
        return new BaseDoubleVectorValueSelector(offset){
            private final double[] doubleVector;
            @Nullable
            private boolean[] nullVector;
            private int id;
            {
                super(offset);
                this.doubleVector = new double[this.offset.getMaxVectorSize()];
                this.nullVector = null;
                this.id = -1;
            }

            @Override
            public double[] getDoubleVector() {
                this.computeVectorsIfNeeded();
                return this.doubleVector;
            }

            @Override
            @Nullable
            public boolean[] getNullVector() {
                this.computeVectorsIfNeeded();
                return this.nullVector;
            }

            private void computeVectorsIfNeeded() {
                if (this.id == this.offset.getId()) {
                    return;
                }
                this.id = this.offset.getId();
                Object[] vals = objectSelector.getObjectVector();
                for (int i = 0; i < objectSelector.getCurrentVectorSize(); ++i) {
                    Object v = vals[i];
                    if (v == null) {
                        if (this.nullVector == null) {
                            this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                        }
                        this.doubleVector[i] = 0.0;
                        this.nullVector[i] = true;
                        continue;
                    }
                    Double d = v instanceof Number ? Double.valueOf(((Number)v).doubleValue()) : Doubles.tryParse((String)String.valueOf(v));
                    if (d != null) {
                        this.doubleVector[i] = d;
                        if (this.nullVector == null) continue;
                        this.nullVector[i] = false;
                        continue;
                    }
                    if (this.nullVector == null) {
                        this.nullVector = new boolean[objectSelector.getMaxVectorSize()];
                    }
                    this.doubleVector[i] = 0.0;
                    this.nullVector[i] = true;
                }
            }
        };
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnSelector selector) {
        NestedDataComplexColumn column = NestedDataComplexColumn.fromColumnSelector(selector, this.columnName);
        if (column == null) {
            return null;
        }
        return column.getColumnIndexSupplier(this.parts);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        if (this.processFromRaw) {
            return ColumnCapabilitiesImpl.createDefault().setType(NestedDataComplexTypeSerde.TYPE).setHasMultipleValues(false);
        }
        return ColumnCapabilitiesImpl.createDefault().setType(this.expectedType != null ? this.expectedType : ColumnType.STRING);
    }

    @Override
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        if (this.processFromRaw) {
            return ColumnCapabilitiesImpl.createDefault().setType(NestedDataComplexTypeSerde.TYPE).setHasMultipleValues(false);
        }
        ColumnCapabilities complexCapabilites = inspector.getColumnCapabilities(this.columnName);
        if (complexCapabilites != null && complexCapabilites.isDictionaryEncoded().isTrue()) {
            return ColumnCapabilitiesImpl.createDefault().setType(this.expectedType != null ? this.expectedType : ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesSorted(true).setDictionaryValuesUnique(true).setHasBitmapIndexes(true);
        }
        return this.capabilities(columnName);
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.columnName);
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedFieldVirtualColumn that = (NestedFieldVirtualColumn)o;
        return this.columnName.equals(that.columnName) && this.outputName.equals(that.outputName) && this.parts.equals(that.parts) && Objects.equals(this.expectedType, that.expectedType) && this.processFromRaw == that.processFromRaw;
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.parts, this.outputName, this.expectedType, this.processFromRaw);
    }

    public String toString() {
        return "NestedFieldVirtualColumn{columnName='" + this.columnName + '\'' + ", outputName='" + this.outputName + '\'' + ", typeHint='" + this.expectedType + '\'' + ", pathParts='" + this.parts + '\'' + ", allowFallback=" + this.processFromRaw + '}';
    }

    public static class FieldDimensionSelector
    extends BaseSingleValueDimensionSelector {
        private final ColumnValueSelector valueSelector;

        public FieldDimensionSelector(ColumnValueSelector valueSelector) {
            this.valueSelector = valueSelector;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("valueSelector", this.valueSelector);
        }

        @Override
        @Nullable
        protected String getValue() {
            Object val = this.valueSelector.getObject();
            if (val == null || val instanceof String) {
                return (String)val;
            }
            return String.valueOf(val);
        }
    }

    public static class RawFieldVectorObjectSelector
    implements VectorObjectSelector {
        private final VectorObjectSelector baseSelector;
        private final List<NestedPathPart> parts;
        private final Object[] vector;

        public RawFieldVectorObjectSelector(VectorObjectSelector baseSelector, List<NestedPathPart> parts) {
            this.baseSelector = baseSelector;
            this.parts = parts;
            this.vector = new Object[baseSelector.getMaxVectorSize()];
        }

        @Override
        public Object[] getObjectVector() {
            Object[] baseVector = this.baseSelector.getObjectVector();
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                this.vector[i] = this.compute(baseVector[i]);
            }
            return this.vector;
        }

        @Override
        public int getMaxVectorSize() {
            return this.baseSelector.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.baseSelector.getCurrentVectorSize();
        }

        private Object compute(Object input) {
            StructuredData data = StructuredData.wrap(input);
            return StructuredData.wrap(NestedPathFinder.find(data == null ? null : data.getValue(), this.parts));
        }
    }

    public static class RawFieldColumnSelector
    implements ColumnValueSelector<Object> {
        protected final ColumnValueSelector baseSelector;
        protected final List<NestedPathPart> parts;

        public RawFieldColumnSelector(ColumnValueSelector baseSelector, List<NestedPathPart> parts) {
            this.baseSelector = baseSelector;
            this.parts = parts;
        }

        @Override
        public double getDouble() {
            StructuredData data = (StructuredData)this.getObject();
            if (data != null && data.getValue() instanceof Number) {
                return ((Number)data.getValue()).doubleValue();
            }
            return 0.0;
        }

        @Override
        public float getFloat() {
            StructuredData data = (StructuredData)this.getObject();
            if (data != null && data.getValue() instanceof Number) {
                return ((Number)data.getValue()).floatValue();
            }
            return 0.0f;
        }

        @Override
        public long getLong() {
            StructuredData data = (StructuredData)this.getObject();
            if (data != null && data.getValue() instanceof Number) {
                return ((Number)data.getValue()).longValue();
            }
            return 0L;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseSelector", this.baseSelector);
            inspector.visit("parts", this.parts);
        }

        @Override
        public boolean isNull() {
            StructuredData data = (StructuredData)this.getObject();
            return data == null || !(data.getValue() instanceof Number);
        }

        @Override
        @Nullable
        public Object getObject() {
            StructuredData data = StructuredData.wrap(this.baseSelector.getObject());
            return StructuredData.wrap(NestedPathFinder.find(data == null ? null : data.getValue(), this.parts));
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }
    }

    public static class RawFieldLiteralColumnValueSelector
    extends RawFieldColumnSelector {
        public RawFieldLiteralColumnValueSelector(ColumnValueSelector baseSelector, List<NestedPathPart> parts) {
            super(baseSelector, parts);
        }

        @Override
        public double getDouble() {
            Object o = this.getObject();
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            return 0.0;
        }

        @Override
        public float getFloat() {
            Object o = this.getObject();
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            return 0.0f;
        }

        @Override
        public long getLong() {
            Object o = this.getObject();
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            return 0L;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseSelector", this.baseSelector);
            inspector.visit("parts", this.parts);
        }

        @Override
        public boolean isNull() {
            return !(this.getObject() instanceof Number);
        }

        @Override
        @Nullable
        public Object getObject() {
            StructuredData data = StructuredData.wrap(this.baseSelector.getObject());
            return NestedPathFinder.findLiteral(data == null ? null : data.getValue(), this.parts);
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }
    }
}

