/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadBuffer;
import org.apache.druid.segment.serde.cell.BlockIndexWriter;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class BlockCompressedPayloadBufferFactory {
    private final ByteBufferProvider byteBufferProvider;
    private final SegmentWriteOutMedium writeOutMedium;
    private final CompressionStrategy.Compressor compressor;

    public BlockCompressedPayloadBufferFactory(ByteBufferProvider byteBufferProvider, SegmentWriteOutMedium writeOutMedium, CompressionStrategy.Compressor compressor) {
        this.byteBufferProvider = byteBufferProvider;
        this.writeOutMedium = writeOutMedium;
        this.compressor = compressor;
    }

    public BlockCompressedPayloadBuffer create() throws IOException {
        Closer closer = Closer.create();
        ResourceHolder<ByteBuffer> currentBlockHolder = this.byteBufferProvider.get();
        closer.register(currentBlockHolder);
        ByteBuffer compressedBlockByteBuffer = this.compressor.allocateOutBuffer(((ByteBuffer)currentBlockHolder.get()).limit(), closer);
        return new BlockCompressedPayloadBuffer((ByteBuffer)currentBlockHolder.get(), compressedBlockByteBuffer, new BlockIndexWriter(this.writeOutMedium.makeWriteOutBytes()), this.writeOutMedium.makeWriteOutBytes(), closer, this.compressor);
    }
}

