/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;

public abstract class StructuredDataProcessor {
    public abstract int processLiteralField(ArrayList<NestedPathPart> var1, Object var2);

    public ProcessResults processFields(Object raw) {
        ArrayDeque<Field> toProcess = new ArrayDeque<Field>();
        raw = StructuredData.unwrap(raw);
        ArrayList<NestedPathPart> newPath = new ArrayList<NestedPathPart>();
        if (raw instanceof Map) {
            toProcess.add(new MapField(newPath, (Map)raw));
        } else if (raw instanceof List) {
            toProcess.add(new ListField(newPath, (List)raw));
        } else {
            return new ProcessResults().addLiteralField(newPath, this.processLiteralField(newPath, raw));
        }
        ProcessResults accumulator = new ProcessResults();
        while (!toProcess.isEmpty()) {
            Field next = (Field)toProcess.poll();
            if (next instanceof MapField) {
                accumulator.merge(this.processMapField(toProcess, (MapField)next));
                continue;
            }
            if (!(next instanceof ListField)) continue;
            accumulator.merge(this.processListField(toProcess, (ListField)next));
        }
        return accumulator;
    }

    private ProcessResults processMapField(Queue<Field> toProcess, MapField map) {
        ProcessResults processResults = new ProcessResults().withSize(16);
        for (Map.Entry<String, ?> entry : map.getMap().entrySet()) {
            processResults.addSize(StructuredDataProcessor.estimateStringSize(entry.getKey()));
            Object value = StructuredData.unwrap(entry.getValue());
            ArrayList<NestedPathPart> newPath = new ArrayList<NestedPathPart>(map.getPath());
            newPath.add(new NestedPathField(entry.getKey()));
            if (value instanceof List) {
                List theList = (List)value;
                toProcess.add(new ListField(newPath, theList));
                continue;
            }
            if (value instanceof Map) {
                toProcess.add(new MapField(newPath, (Map)value));
                continue;
            }
            processResults.addLiteralField(newPath, this.processLiteralField(newPath, value));
        }
        return processResults;
    }

    private ProcessResults processListField(Queue<Field> toProcess, ListField list) {
        ProcessResults results = new ProcessResults().withSize(8);
        List<?> theList = list.getList();
        for (int i = 0; i < theList.size(); ++i) {
            ArrayList<NestedPathPart> newPath = new ArrayList<NestedPathPart>(list.getPath());
            newPath.add(new NestedPathArrayElement(i));
            Object element = StructuredData.unwrap(theList.get(i));
            if (element instanceof Map) {
                toProcess.add(new MapField(newPath, (Map)element));
                continue;
            }
            if (element instanceof List) {
                toProcess.add(new ListField(newPath, (List)element));
                continue;
            }
            results.addLiteralField(newPath, this.processLiteralField(newPath, element));
        }
        return results;
    }

    public static int estimateStringSize(@Nullable String value) {
        return value == null ? 0 : 44 + 2 * value.length();
    }

    public static int getLongObjectEstimateSize() {
        return 16;
    }

    public static int getDoubleObjectEstimateSize() {
        return 16;
    }

    public static class ProcessResults {
        private Set<ArrayList<NestedPathPart>> literalFields = new HashSet<ArrayList<NestedPathPart>>();
        private int estimatedSize = 0;

        public Set<ArrayList<NestedPathPart>> getLiteralFields() {
            return this.literalFields;
        }

        public int getEstimatedSize() {
            return this.estimatedSize;
        }

        public ProcessResults addSize(int size) {
            this.estimatedSize += size;
            return this;
        }

        public ProcessResults addLiteralField(ArrayList<NestedPathPart> fieldPath, int sizeOfValue) {
            this.literalFields.add(fieldPath);
            this.estimatedSize += sizeOfValue;
            return this;
        }

        public ProcessResults withSize(int size) {
            this.estimatedSize = size;
            return this;
        }

        public ProcessResults merge(ProcessResults other) {
            this.literalFields.addAll(other.literalFields);
            this.estimatedSize += other.estimatedSize;
            return this;
        }
    }

    static class MapField
    extends Field {
        private final Map<String, ?> map;

        MapField(ArrayList<NestedPathPart> path, Map<String, ?> map) {
            super(path);
            this.map = map;
        }

        public Map<String, ?> getMap() {
            return this.map;
        }
    }

    static class ListField
    extends Field {
        private final List<?> list;

        ListField(ArrayList<NestedPathPart> path, List<?> list) {
            super(path);
            this.list = list;
        }

        public List<?> getList() {
            return this.list;
        }
    }

    static abstract class Field {
        private final ArrayList<NestedPathPart> path;

        protected Field(ArrayList<NestedPathPart> path) {
            this.path = path;
        }

        public ArrayList<NestedPathPart> getPath() {
            return this.path;
        }
    }
}

