/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.GlobalDictionaryIdLookup;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public final class StringFieldColumnWriter
extends GlobalDictionaryEncodedFieldColumnWriter<String> {
    public StringFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec, GlobalDictionaryIdLookup globalDictionaryIdLookup) {
        super(columnName, fieldName, segmentWriteOutMedium, indexSpec, globalDictionaryIdLookup);
    }

    @Override
    String processValue(Object value) {
        return String.valueOf(value);
    }

    @Override
    int lookupGlobalId(String value) {
        return this.globalDictionaryIdLookup.lookupString(value);
    }

    @Override
    void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeLongAndDoubleColumnLength(channel, 0, 0);
        this.encodedValueSerializer.writeTo(channel, smoosher);
    }
}

