/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CloseableUtils;
import org.roaringbitmap.PeekableIntIterator;

public class NestedFieldLiteralDictionaryEncodedColumn<TStringDictionary extends Indexed<ByteBuffer>>
implements DictionaryEncodedColumn<String> {
    private final NestedLiteralTypeInfo.TypeSet types;
    @Nullable
    private final ColumnType singleType;
    private final ColumnarLongs longsColumn;
    private final ColumnarDoubles doublesColumn;
    private final ColumnarInts column;
    private final TStringDictionary globalDictionary;
    private final FixedIndexed<Long> globalLongDictionary;
    private final FixedIndexed<Double> globalDoubleDictionary;
    private final FixedIndexed<Integer> dictionary;
    private final ImmutableBitmap nullBitmap;
    private final int adjustLongId;
    private final int adjustDoubleId;

    public NestedFieldLiteralDictionaryEncodedColumn(NestedLiteralTypeInfo.TypeSet types, ColumnarLongs longsColumn, ColumnarDoubles doublesColumn, ColumnarInts column, TStringDictionary globalDictionary, FixedIndexed<Long> globalLongDictionary, FixedIndexed<Double> globalDoubleDictionary, FixedIndexed<Integer> dictionary, ImmutableBitmap nullBitmap) {
        this.types = types;
        this.singleType = types.getSingleType();
        this.longsColumn = longsColumn;
        this.doublesColumn = doublesColumn;
        this.column = column;
        this.globalDictionary = globalDictionary;
        this.globalLongDictionary = globalLongDictionary;
        this.globalDoubleDictionary = globalDoubleDictionary;
        this.dictionary = dictionary;
        this.nullBitmap = nullBitmap;
        this.adjustLongId = globalDictionary.size();
        this.adjustDoubleId = this.adjustLongId + globalLongDictionary.size();
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        throw new IllegalStateException("Multi-value row not supported");
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        int globalId = this.dictionary.get(id);
        if (globalId < this.globalDictionary.size()) {
            return StringUtils.fromUtf8Nullable((ByteBuffer)((ByteBuffer)this.globalDictionary.get(globalId)));
        }
        if (globalId < this.globalDictionary.size() + this.globalLongDictionary.size()) {
            return String.valueOf(this.globalLongDictionary.get(globalId - this.adjustLongId));
        }
        return String.valueOf(this.globalDoubleDictionary.get(globalId - this.adjustDoubleId));
    }

    @Override
    public int lookupId(String name) {
        int globalId = this.getIdFromGlobalDictionary(name);
        if (globalId < 0) {
            return -1;
        }
        return this.dictionary.indexOf(globalId);
    }

    @Override
    public int getCardinality() {
        return this.dictionary.size();
    }

    public FixedIndexed<Integer> getDictionary() {
        return this.dictionary;
    }

    private int getIdFromGlobalDictionary(@Nullable String val) {
        if (val == null) {
            return 0;
        }
        if (this.singleType != null) {
            switch ((ValueType)this.singleType.getType()) {
                case LONG: {
                    int globalLong = this.globalLongDictionary.indexOf(GuavaUtils.tryParseLong((String)val));
                    if (globalLong < 0) {
                        return -1;
                    }
                    return globalLong + this.adjustLongId;
                }
                case DOUBLE: {
                    int globalDouble = this.globalDoubleDictionary.indexOf(Doubles.tryParse((String)val));
                    if (globalDouble < 0) {
                        return -1;
                    }
                    return globalDouble + this.adjustDoubleId;
                }
            }
            return this.globalDictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer((String)val));
        }
        int candidate = this.globalDictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer((String)val));
        if (candidate < 0 && (candidate = this.globalLongDictionary.indexOf(GuavaUtils.tryParseLong((String)val))) >= 0) {
            candidate += this.adjustLongId;
        }
        if (candidate < 0 && (candidate = this.globalDoubleDictionary.indexOf(Doubles.tryParse((String)val))) >= 0) {
            candidate += this.adjustDoubleId;
        }
        return candidate;
    }

    @Override
    public DimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        class StringDimensionSelector
        extends AbstractDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup {
            private final SingleIndexedInt row = new SingleIndexedInt();

            StringDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public float getFloat() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    return 0.0f;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                    Float f = Floats.tryParse((String)StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId))));
                    return f == null ? 0.0f : f.floatValue();
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                    return ((Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId)).floatValue();
                }
                return ((Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId)).floatValue();
            }

            @Override
            public double getDouble() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    return 0.0;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                    Double d = Doubles.tryParse((String)StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId))));
                    return d == null ? 0.0 : d;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                    return ((Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId)).doubleValue();
                }
                return (Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId);
            }

            @Override
            public long getLong() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    return 0L;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                    Long l = GuavaUtils.tryParseLong((String)StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId))));
                    return l == null ? 0L : l;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                    return (Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId);
                }
                return ((Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId)).longValue();
            }

            @Override
            public boolean isNull() {
                return (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(this.getRowValue()) == 0;
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", NestedFieldLiteralDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality());
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply((Object)this.lookupName(id));
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", NestedFieldLiteralDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", NestedFieldLiteralDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }

            @Override
            public int getValueCardinality() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            public String lookupName(int id) {
                String value = NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(id);
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn == null) {
                    return NestedFieldLiteralDictionaryEncodedColumn.this.lookupId(name);
                }
                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
            }
        }
        return new StringDimensionSelector();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        if (this.singleType != null) {
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.LONG)) {
                return new LongColumnSelector(){
                    private PeekableIntIterator nullIterator;
                    private int nullMark;
                    private int offsetMark;
                    {
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.nullMark = -1;
                        this.offsetMark = -1;
                    }

                    @Override
                    public long getLong() {
                        return NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn.get(offset.getOffset());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("longColumn", NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn);
                        inspector.visit("nullBitmap", NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap);
                    }

                    @Override
                    public boolean isNull() {
                        int i = offset.getOffset();
                        if (i < this.offsetMark) {
                            this.nullMark = -1;
                            this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = i;
                        if (this.nullMark < i) {
                            this.nullIterator.advanceIfNeeded(this.offsetMark);
                            if (this.nullIterator.hasNext()) {
                                this.nullMark = this.nullIterator.next();
                            }
                        }
                        return this.nullMark == this.offsetMark;
                    }
                };
            }
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.DOUBLE)) {
                return new DoubleColumnSelector(){
                    private PeekableIntIterator nullIterator;
                    private int nullMark;
                    private int offsetMark;
                    {
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.nullMark = -1;
                        this.offsetMark = -1;
                    }

                    @Override
                    public double getDouble() {
                        return NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn.get(offset.getOffset());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("doubleColumn", NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn);
                        inspector.visit("nullBitmap", NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap);
                    }

                    @Override
                    public boolean isNull() {
                        int i = offset.getOffset();
                        if (i < this.offsetMark) {
                            this.nullMark = -1;
                            this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = i;
                        if (this.nullMark < i) {
                            this.nullIterator.advanceIfNeeded(this.offsetMark);
                            if (this.nullIterator.hasNext()) {
                                this.nullMark = this.nullIterator.next();
                            }
                        }
                        return this.nullMark == this.offsetMark;
                    }
                };
            }
        }
        if (this.singleType == null) {
            return new ColumnValueSelector<Object>(){
                private PeekableIntIterator nullIterator;
                private int nullMark;
                private int offsetMark;
                {
                    this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                    this.nullMark = -1;
                    this.offsetMark = -1;
                }

                @Override
                @Nullable
                public Object getObject() {
                    int localId = NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                        return StringUtils.fromUtf8Nullable((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                        return NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId);
                    }
                    return NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId);
                }

                @Override
                public float getFloat() {
                    int localId = NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return 0.0f;
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                        Float f = Floats.tryParse((String)StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId))));
                        return f == null ? 0.0f : f.floatValue();
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                        return ((Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId)).floatValue();
                    }
                    return ((Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId)).floatValue();
                }

                @Override
                public double getDouble() {
                    int localId = NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return 0.0;
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                        Double d = Doubles.tryParse((String)StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId))));
                        return d == null ? 0.0 : d;
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                        return ((Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId)).doubleValue();
                    }
                    return (Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId);
                }

                @Override
                public long getLong() {
                    int localId = NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return 0L;
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                        Long l = GuavaUtils.tryParseLong((String)StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId))));
                        return l == null ? 0L : l;
                    }
                    if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                        return (Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId);
                    }
                    return ((Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId)).longValue();
                }

                @Override
                public boolean isNull() {
                    int i = offset.getOffset();
                    if (i < this.offsetMark) {
                        this.nullMark = -1;
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                    }
                    this.offsetMark = i;
                    if (this.nullMark < i) {
                        this.nullIterator.advanceIfNeeded(this.offsetMark);
                        if (this.nullIterator.hasNext()) {
                            this.nullMark = this.nullIterator.next();
                        }
                    }
                    return this.nullMark == this.offsetMark;
                }

                @Override
                public Class<?> classOfObject() {
                    return Object.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("longColumn", NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn);
                    inspector.visit("nullBitmap", NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap);
                }
            };
        }
        return this.makeDimensionSelector(offset, null);
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringDictionaryEncodedColumn.StringSingleValueDimensionVectorSelector {
            public StringVectorSelector() {
                super(NestedFieldLiteralDictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return (ByteBuffer)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.indexOf(id));
            }

            @Override
            public boolean supportsLookupNameUtf8() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.singleType != null && NestedFieldLiteralDictionaryEncodedColumn.this.singleType.is((TypeDescriptor)ValueType.STRING);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringDictionaryEncodedColumn.StringVectorObjectSelector {
            public StringVectorSelector() {
                super(NestedFieldLiteralDictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(id);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        if (this.singleType != null) {
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.LONG)) {
                return new BaseLongVectorValueSelector(offset){
                    private final long[] valueVector;
                    @Nullable
                    private boolean[] nullVector;
                    private int id;
                    @Nullable
                    private PeekableIntIterator nullIterator;
                    private int offsetMark;
                    {
                        this.valueVector = new long[this.offset.getMaxVectorSize()];
                        this.nullVector = null;
                        this.id = -1;
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.offsetMark = -1;
                    }

                    @Override
                    public long[] getLongVector() {
                        this.computeVectorsIfNeeded();
                        return this.valueVector;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        this.computeVectorsIfNeeded();
                        return this.nullVector;
                    }

                    private void computeVectorsIfNeeded() {
                        if (this.id == this.offset.getId()) {
                            return;
                        }
                        if (this.offset.isContiguous()) {
                            if (this.offset.getStartOffset() < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                            NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                        } else {
                            int[] offsets = this.offset.getOffsets();
                            if (offsets[offsets.length - 1] < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = offsets[offsets.length - 1];
                            NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                        }
                        this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                        this.id = this.offset.getId();
                    }
                };
            }
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.DOUBLE)) {
                return new BaseDoubleVectorValueSelector(offset){
                    private final double[] valueVector;
                    @Nullable
                    private boolean[] nullVector;
                    private int id;
                    @Nullable
                    private PeekableIntIterator nullIterator;
                    private int offsetMark;
                    {
                        this.valueVector = new double[this.offset.getMaxVectorSize()];
                        this.nullVector = null;
                        this.id = -1;
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap != null ? NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator() : null;
                        this.offsetMark = -1;
                    }

                    @Override
                    public double[] getDoubleVector() {
                        this.computeVectorsIfNeeded();
                        return this.valueVector;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        this.computeVectorsIfNeeded();
                        return this.nullVector;
                    }

                    private void computeVectorsIfNeeded() {
                        if (this.id == this.offset.getId()) {
                            return;
                        }
                        if (this.offset.isContiguous()) {
                            if (this.offset.getStartOffset() < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                            NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                        } else {
                            int[] offsets = this.offset.getOffsets();
                            if (offsets[offsets.length - 1] < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = offsets[offsets.length - 1];
                            NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                        }
                        this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                        this.id = this.offset.getId();
                    }
                };
            }
            throw new UOE("Cannot make vector value selector for [%s] typed nested field", new Object[]{this.types});
        }
        throw new UOE("Cannot make vector value selector for variant typed [%s] nested field", new Object[]{this.types});
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll((Closeable)this.column, (Closeable[])new Closeable[]{this.longsColumn, this.doublesColumn});
    }
}

