/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnV3;
import org.apache.druid.segment.nested.NestedDataColumnV4;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;

public class NestedDataColumnSupplier
implements Supplier<ComplexColumn> {
    private final byte version;
    private final NestedDataColumnMetadata metadata;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final GenericIndexed<String> fields;
    private final NestedLiteralTypeInfo fieldInfo;
    private final GenericIndexed<ByteBuffer> dictionary;
    private final Supplier<FrontCodedIndexed> frontCodedDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final ColumnConfig columnConfig;
    private final SmooshedFileMapper fileMapper;

    public NestedDataColumnSupplier(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper) {
        this(bb, columnBuilder, columnConfig, jsonMapper, (TypeStrategy<Long>)ColumnType.LONG.getStrategy(), (TypeStrategy<Double>)ColumnType.DOUBLE.getStrategy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public NestedDataColumnSupplier(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper, TypeStrategy<Long> longTypeStrategy, TypeStrategy<Double> doubleTypeStrategy) {
        this.version = bb.get();
        if (this.version != 3 && this.version != 4) throw new RE("Unknown version " + this.version, new Object[0]);
        try {
            SmooshedFileMapper mapper = columnBuilder.getFileMapper();
            this.metadata = (NestedDataColumnMetadata)jsonMapper.readValue(IndexMerger.SERIALIZER_UTILS.readString(bb), NestedDataColumnMetadata.class);
            this.fields = GenericIndexed.read(bb, GenericIndexed.STRING_STRATEGY, mapper);
            this.fieldInfo = NestedLiteralTypeInfo.read(bb, this.fields.size());
            ByteBuffer stringDictionaryBuffer = this.loadInternalFile(mapper, "__stringDictionary");
            int dictionaryStartPosition = stringDictionaryBuffer.position();
            byte dictionaryVersion = stringDictionaryBuffer.get();
            if (dictionaryVersion == 127) {
                byte encodingId = stringDictionaryBuffer.get();
                if (encodingId == 1) {
                    this.frontCodedDictionarySupplier = FrontCodedIndexed.read(stringDictionaryBuffer, this.metadata.getByteOrder());
                    this.dictionary = null;
                } else {
                    if (encodingId != 0) throw new ISE("impossible, unknown encoding strategy id: %s", new Object[]{encodingId});
                    this.dictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                    this.frontCodedDictionarySupplier = null;
                }
            } else {
                stringDictionaryBuffer.position(dictionaryStartPosition);
                this.dictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                this.frontCodedDictionarySupplier = null;
            }
            ByteBuffer longDictionaryBuffer = this.loadInternalFile(mapper, "__longDictionary");
            this.longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, longTypeStrategy, this.metadata.getByteOrder(), 8);
            ByteBuffer doubleDictionaryBuffer = this.loadInternalFile(mapper, "__doubleDictionary");
            this.doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, doubleTypeStrategy, this.metadata.getByteOrder(), 8);
            ByteBuffer rawBuffer = this.loadInternalFile(mapper, "__raw");
            this.compressedRawColumnSupplier = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(NestedDataColumnSerializer.getInternalFileName(this.metadata.getFileNameBase(), "__raw"), rawBuffer, this.metadata.getByteOrder(), mapper);
            if (this.metadata.hasNulls().booleanValue()) {
                ByteBuffer nullIndexBuffer = this.loadInternalFile(mapper, "__nullIndex");
                this.nullValues = this.metadata.getBitmapSerdeFactory().getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
            } else {
                this.nullValues = this.metadata.getBitmapSerdeFactory().getBitmapFactory().makeEmptyImmutableBitmap();
            }
        }
        catch (IOException ex) {
            throw new RE((Throwable)ex, "Failed to deserialize V%s column.", new Object[]{this.version});
        }
        this.fileMapper = (SmooshedFileMapper)Preconditions.checkNotNull((Object)columnBuilder.getFileMapper(), (Object)"Null fileMapper");
        this.columnConfig = columnConfig;
    }

    public ComplexColumn get() {
        if (this.version == 3) {
            return this.makeV3();
        }
        return this.makeV4();
    }

    private NestedDataColumnV3 makeV3() {
        if (this.frontCodedDictionarySupplier != null) {
            return new NestedDataColumnV3<FrontCodedIndexed>(this.metadata, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.frontCodedDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper);
        }
        return new NestedDataColumnV3(this.metadata, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.dictionary::singleThreaded, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper);
    }

    private NestedDataColumnV4 makeV4() {
        if (this.frontCodedDictionarySupplier != null) {
            return new NestedDataColumnV4<FrontCodedIndexed>(this.metadata, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.frontCodedDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper);
        }
        return new NestedDataColumnV4(this.metadata, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.dictionary::singleThreaded, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper);
    }

    private ByteBuffer loadInternalFile(SmooshedFileMapper fileMapper, String internalFileName) throws IOException {
        return fileMapper.mapFile(NestedDataColumnSerializer.getInternalFileName(this.metadata.getFileNameBase(), internalFileName));
    }
}

