/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public class LocalDimensionDictionary {
    private final Int2IntOpenHashMap globalIdToLocalId = new Int2IntOpenHashMap();
    private int nextLocalId = 0;

    public LocalDimensionDictionary() {
        this.globalIdToLocalId.defaultReturnValue(-1);
    }

    public Int2IntOpenHashMap getGlobalIdToLocalId() {
        return this.globalIdToLocalId;
    }

    public int add(int originalValue) {
        int prev = this.globalIdToLocalId.get(originalValue);
        if (prev >= 0) {
            return prev;
        }
        int index = this.nextLocalId++;
        this.globalIdToLocalId.put(originalValue, index);
        return index;
    }

    public int size() {
        return this.nextLocalId;
    }
}

