/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarIntsSerializer;
import org.apache.druid.segment.nested.GlobalDictionaryIdLookup;
import org.apache.druid.segment.nested.LocalDimensionDictionary;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class GlobalDictionaryEncodedFieldColumnWriter<T> {
    private static final Logger log = new Logger(GlobalDictionaryEncodedFieldColumnWriter.class);
    protected final SegmentWriteOutMedium segmentWriteOutMedium;
    protected final String columnName;
    protected final String fieldName;
    protected final IndexSpec indexSpec;
    protected final GlobalDictionaryIdLookup globalDictionaryIdLookup;
    protected final LocalDimensionDictionary localDictionary = new LocalDimensionDictionary();
    protected FixedIndexedIntWriter intermediateValueWriter;
    protected int flags = 0;
    protected DictionaryEncodedColumnPartSerde.VERSION version = null;
    protected SingleValueColumnarIntsSerializer encodedValueSerializer;
    protected int cursorPosition;

    protected GlobalDictionaryEncodedFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec, GlobalDictionaryIdLookup globalDictionaryIdLookup) {
        this.columnName = columnName;
        this.fieldName = fieldName;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.globalDictionaryIdLookup = globalDictionaryIdLookup;
    }

    T processValue(Object value) {
        return (T)value;
    }

    void writeValue(@Nullable T value) throws IOException {
    }

    abstract int lookupGlobalId(T var1);

    public void open() throws IOException {
        this.intermediateValueWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, false);
        this.intermediateValueWriter.open();
        this.cursorPosition = 0;
    }

    public void addValue(int row, Object val) throws IOException {
        if (row > this.cursorPosition) {
            this.fillNull(row);
        }
        T value = this.processValue(val);
        int globalId = this.lookupGlobalId(value);
        int localId = this.localDictionary.add(globalId);
        this.intermediateValueWriter.write(localId);
        this.writeValue(value);
        ++this.cursorPosition;
    }

    private void fillNull(int row) throws IOException {
        T value = this.processValue(null);
        int localId = this.localDictionary.add(0);
        while (this.cursorPosition < row) {
            this.intermediateValueWriter.write(localId);
            this.writeValue(value);
            ++this.cursorPosition;
        }
    }

    long getSerializedColumnSize() throws IOException {
        return 8L + this.encodedValueSerializer.getSerializedSize();
    }

    abstract void writeColumnTo(WritableByteChannel var1, FileSmoosher var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(int finalRowCount, FileSmoosher smoosher) throws IOException {
        if (finalRowCount > this.cursorPosition) {
            this.fillNull(finalRowCount);
        }
        SegmentWriteOutMedium tmpWriteoutMedium = this.segmentWriteOutMedium.makeChildWriteOutMedium();
        final FixedIndexedIntWriter sortedDictionaryWriter = new FixedIndexedIntWriter(tmpWriteoutMedium, true);
        sortedDictionaryWriter.open();
        final GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(tmpWriteoutMedium, this.columnName, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        bitmapIndexWriter.open();
        bitmapIndexWriter.setObjectsNotSorted();
        Int2IntOpenHashMap globalToUnsorted = this.localDictionary.getGlobalIdToLocalId();
        int[] unsortedToGlobal = new int[this.localDictionary.size()];
        IntIterator intIterator = globalToUnsorted.keySet().iterator();
        while (intIterator.hasNext()) {
            int key;
            unsortedToGlobal[globalToUnsorted.get((int)key)] = key = ((Integer)intIterator.next()).intValue();
        }
        int[] sortedGlobal = new int[unsortedToGlobal.length];
        System.arraycopy(unsortedToGlobal, 0, sortedGlobal, 0, unsortedToGlobal.length);
        IntArrays.unstableSort((int[])sortedGlobal);
        int[] unsortedToSorted = new int[unsortedToGlobal.length];
        MutableBitmap[] bitmaps = new MutableBitmap[sortedGlobal.length];
        for (int index = 0; index < sortedGlobal.length; ++index) {
            int globalId = sortedGlobal[index];
            sortedDictionaryWriter.write(globalId);
            int unsortedId = globalToUnsorted.get(globalId);
            unsortedToSorted[unsortedId] = index;
            bitmaps[index] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        }
        this.openColumnSerializer(tmpWriteoutMedium, sortedGlobal[sortedGlobal.length - 1]);
        IntIterator rows = this.intermediateValueWriter.getIterator();
        int rowCount = 0;
        while (rows.hasNext()) {
            int unsortedLocalId = rows.nextInt();
            int sortedLocalId = unsortedToSorted[unsortedLocalId];
            this.encodedValueSerializer.addValue(sortedLocalId);
            bitmaps[sortedLocalId].add(rowCount++);
        }
        for (MutableBitmap bitmap : bitmaps) {
            bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
        }
        Serializer fieldSerializer = new Serializer(){

            @Override
            public long getSerializedSize() throws IOException {
                return 5L + sortedDictionaryWriter.getSerializedSize() + bitmapIndexWriter.getSerializedSize() + GlobalDictionaryEncodedFieldColumnWriter.this.getSerializedColumnSize();
            }

            @Override
            public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap(new byte[]{GlobalDictionaryEncodedFieldColumnWriter.this.version.asByte()}));
                channel.write(ByteBuffer.wrap(Ints.toByteArray((int)GlobalDictionaryEncodedFieldColumnWriter.this.flags)));
                sortedDictionaryWriter.writeTo(channel, smoosher);
                GlobalDictionaryEncodedFieldColumnWriter.this.writeColumnTo(channel, smoosher);
                bitmapIndexWriter.writeTo(channel, smoosher);
            }
        };
        String fieldFileName = NestedDataColumnSerializer.getInternalFileName(this.columnName, this.fieldName);
        long size = fieldSerializer.getSerializedSize();
        log.debug("Column [%s] serializing [%s] field of size [%d].", new Object[]{this.columnName, this.fieldName, size});
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(fieldFileName, size);){
            fieldSerializer.writeTo((WritableByteChannel)smooshChannel, smoosher);
        }
        finally {
            tmpWriteoutMedium.close();
        }
    }

    private void openColumnSerializer(SegmentWriteOutMedium medium, int maxId) throws IOException {
        if (this.indexSpec.getDimensionCompression() != CompressionStrategy.UNCOMPRESSED) {
            this.version = DictionaryEncodedColumnPartSerde.VERSION.COMPRESSED;
            this.encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.fieldName, medium, this.columnName, maxId, this.indexSpec.getDimensionCompression());
        } else {
            this.encodedValueSerializer = new VSizeColumnarIntsSerializer(medium, maxId);
            this.version = DictionaryEncodedColumnPartSerde.VERSION.UNCOMPRESSED_SINGLE_VALUE;
        }
        this.encodedValueSerializer.open();
    }

    public void writeLongAndDoubleColumnLength(WritableByteChannel channel, int longLength, int doubleLength) throws IOException {
        ByteBuffer intBuffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        intBuffer.position(0);
        intBuffer.putInt(longLength);
        intBuffer.flip();
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)intBuffer);
        intBuffer.position(0);
        intBuffer.limit(intBuffer.capacity());
        intBuffer.putInt(doubleLength);
        intBuffer.flip();
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)intBuffer);
    }
}

