/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.ReferenceCountedObject;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;

public class JoinableClause
implements ReferenceCountedObject {
    private final String prefix;
    private final Joinable joinable;
    private final JoinType joinType;
    private final JoinConditionAnalysis condition;

    public JoinableClause(String prefix, Joinable joinable, JoinType joinType, JoinConditionAnalysis condition) {
        this.prefix = JoinPrefixUtils.validatePrefix(prefix);
        this.joinable = (Joinable)Preconditions.checkNotNull((Object)joinable, (Object)"joinable");
        this.joinType = (JoinType)((Object)Preconditions.checkNotNull((Object)((Object)joinType), (Object)"joinType"));
        this.condition = (JoinConditionAnalysis)Preconditions.checkNotNull((Object)condition, (Object)"condition");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Joinable getJoinable() {
        return this.joinable;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinConditionAnalysis getCondition() {
        return this.condition;
    }

    public List<String> getAvailableColumnsPrefixed() {
        return this.joinable.getAvailableColumns().stream().map(columnName -> this.prefix + columnName).collect(Collectors.toList());
    }

    public boolean includesColumn(String columnName) {
        return JoinPrefixUtils.isPrefixedBy(columnName, this.prefix);
    }

    public String unprefix(String columnName) {
        if (this.includesColumn(columnName)) {
            return columnName.substring(this.prefix.length());
        }
        throw new IAE("Column[%s] does not start with prefix[%s]", new Object[]{columnName, this.prefix});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinableClause that = (JoinableClause)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.joinable, that.joinable) && this.joinType == that.joinType && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.joinable, this.joinType, this.condition});
    }

    public String toString() {
        return "JoinableClause{prefix='" + this.prefix + '\'' + ", joinable=" + this.joinable + ", joinType=" + (Object)((Object)this.joinType) + ", condition=" + this.condition + '}';
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return this.joinable.acquireReferences();
    }
}

