/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.VirtualColumns;

public class IncrementalIndexSchema {
    private final long minTimestamp;
    private final TimestampSpec timestampSpec;
    private final Granularity gran;
    private final VirtualColumns virtualColumns;
    private final DimensionsSpec dimensionsSpec;
    private final AggregatorFactory[] metrics;
    private final boolean rollup;

    public IncrementalIndexSchema(long minTimestamp, TimestampSpec timestampSpec, Granularity gran, VirtualColumns virtualColumns, DimensionsSpec dimensionsSpec, AggregatorFactory[] metrics, boolean rollup) {
        this.minTimestamp = minTimestamp;
        this.timestampSpec = timestampSpec;
        this.gran = gran;
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimensionsSpec = dimensionsSpec;
        this.metrics = metrics;
        this.rollup = rollup;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    public Granularity getGran() {
        return this.gran;
    }

    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public AggregatorFactory[] getMetrics() {
        return this.metrics;
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public static class Builder {
        private long minTimestamp = 0L;
        private TimestampSpec timestampSpec;
        private Granularity gran = Granularities.NONE;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        private DimensionsSpec dimensionsSpec = DimensionsSpec.EMPTY;
        private AggregatorFactory[] metrics = new AggregatorFactory[0];
        private boolean rollup = true;

        public Builder withMinTimestamp(long minTimestamp) {
            this.minTimestamp = minTimestamp;
            return this;
        }

        public Builder withTimestampSpec(TimestampSpec timestampSpec) {
            this.timestampSpec = timestampSpec;
            return this;
        }

        public Builder withQueryGranularity(Granularity gran) {
            this.gran = gran;
            return this;
        }

        public Builder withVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public Builder withDimensionsSpec(@Nullable DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec == null ? DimensionsSpec.EMPTY : dimensionsSpec;
            return this;
        }

        @Deprecated
        public Builder withDimensionsSpec(@Nullable InputRowParser parser) {
            this.dimensionsSpec = parser != null && parser.getParseSpec() != null && parser.getParseSpec().getDimensionsSpec() != null ? parser.getParseSpec().getDimensionsSpec() : DimensionsSpec.EMPTY;
            return this;
        }

        public Builder withMetrics(AggregatorFactory ... metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withRollup(boolean rollup) {
            this.rollup = rollup;
            return this;
        }

        public IncrementalIndexSchema build() {
            return new IncrementalIndexSchema(this.minTimestamp, this.timestampSpec, this.gran, this.virtualColumns, this.dimensionsSpec, this.metrics, this.rollup);
        }
    }
}

