/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Utf8CodingException;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.SafeWritableBase;
import org.apache.druid.segment.data.SafeWritableBuffer;

public class SafeWritableMemory
extends SafeWritableBase
implements WritableMemory {
    public static SafeWritableMemory wrap(byte[] bytes) {
        return SafeWritableMemory.wrap(ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()), 0, bytes.length);
    }

    public static SafeWritableMemory wrap(ByteBuffer buffer) {
        return SafeWritableMemory.wrap(buffer.duplicate().order(buffer.order()), 0, buffer.capacity());
    }

    public static SafeWritableMemory wrap(ByteBuffer buffer, ByteOrder byteOrder) {
        return SafeWritableMemory.wrap(buffer.duplicate().order(byteOrder), 0, buffer.capacity());
    }

    public static SafeWritableMemory wrap(ByteBuffer buffer, int offset, int size) {
        ByteBuffer dupe = buffer.duplicate().order(buffer.order());
        dupe.position(offset);
        dupe.limit(offset + size);
        return new SafeWritableMemory(dupe.slice().order(buffer.order()));
    }

    public SafeWritableMemory(ByteBuffer buffer) {
        super(buffer);
    }

    public Memory region(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        return this.writableRegion(offsetBytes, capacityBytes, byteOrder);
    }

    public Buffer asBuffer(ByteOrder byteOrder) {
        return this.asWritableBuffer(byteOrder);
    }

    public void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffsetBooleans, int lengthBooleans) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthBooleans; ++j) {
            dstArray[dstOffsetBooleans + j] = this.buffer.get(offset + j) != 0;
        }
    }

    public void getByteArray(long offsetBytes, byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthBytes; ++j) {
            dstArray[dstOffsetBytes + j] = this.buffer.get(offset + j);
        }
    }

    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthChars; ++j) {
            dstArray[dstOffsetChars + j] = this.buffer.getChar(offset + j * 2);
        }
    }

    public int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, Appendable dst) throws IOException, Utf8CodingException {
        ByteBuffer dupe = this.buffer.asReadOnlyBuffer().order(this.buffer.order());
        dupe.position(Ints.checkedCast((long)offsetBytes));
        String s = StringUtils.fromUtf8((ByteBuffer)dupe, (int)utf8LengthBytes);
        dst.append(s);
        return s.length();
    }

    public int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, StringBuilder dst) throws Utf8CodingException {
        ByteBuffer dupe = this.buffer.asReadOnlyBuffer().order(this.buffer.order());
        dupe.position(Ints.checkedCast((long)offsetBytes));
        String s = StringUtils.fromUtf8((ByteBuffer)dupe, (int)utf8LengthBytes);
        dst.append(s);
        return s.length();
    }

    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthDoubles; ++j) {
            dstArray[dstOffsetDoubles + j] = this.buffer.getDouble(offset + j * 8);
        }
    }

    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthFloats; ++j) {
            dstArray[dstOffsetFloats + j] = this.buffer.getFloat(offset + j * 4);
        }
    }

    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthInts; ++j) {
            dstArray[dstOffsetInts + j] = this.buffer.getInt(offset + j * 4);
        }
    }

    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthLongs; ++j) {
            dstArray[dstOffsetLongs + j] = this.buffer.getLong(offset + j * 8);
        }
    }

    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int j = 0; j < lengthShorts; ++j) {
            dstArray[dstOffsetShorts + j] = this.buffer.getShort(offset + j * 2);
        }
    }

    public int compareTo(long thisOffsetBytes, long thisLengthBytes, Memory that, long thatOffsetBytes, long thatLengthBytes) {
        int thisLength = Ints.checkedCast((long)thisLengthBytes);
        int thatLength = Ints.checkedCast((long)thatLengthBytes);
        int commonLength = Math.min(thisLength, thatLength);
        for (int i = 0; i < commonLength; ++i) {
            int cmp = Byte.compare(this.getByte(thisOffsetBytes + (long)i), that.getByte(thatOffsetBytes + (long)i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(thisLength, thatLength);
    }

    public void copyTo(long srcOffsetBytes, WritableMemory destination, long dstOffsetBytes, long lengthBytes) {
        int offset = Ints.checkedCast((long)srcOffsetBytes);
        int i = 0;
        while ((long)i < lengthBytes) {
            destination.putByte(dstOffsetBytes + (long)i, this.buffer.get(offset + i));
            ++i;
        }
    }

    public void writeTo(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        ByteBuffer dupe = this.buffer.duplicate();
        dupe.position(Ints.checkedCast((long)offsetBytes));
        dupe.limit(dupe.position() + Ints.checkedCast((long)lengthBytes));
        ByteBuffer view = dupe.slice();
        view.order(this.buffer.order());
        out.write(view);
    }

    public boolean equalTo(long thisOffsetBytes, Object that, long thatOffsetBytes, long lengthBytes) {
        if (!(that instanceof SafeWritableMemory)) {
            return false;
        }
        return this.compareTo(thisOffsetBytes, lengthBytes, (Memory)((SafeWritableMemory)that), thatOffsetBytes, lengthBytes) == 0;
    }

    public WritableMemory writableRegion(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        ByteBuffer dupe = this.buffer.duplicate().order(this.buffer.order());
        int sizeBytes = Ints.checkedCast((long)capacityBytes);
        dupe.position(Ints.checkedCast((long)offsetBytes));
        dupe.limit(dupe.position() + sizeBytes);
        ByteBuffer view = dupe.slice();
        view.order(byteOrder);
        return new SafeWritableMemory(view);
    }

    public WritableBuffer asWritableBuffer(ByteOrder byteOrder) {
        return new SafeWritableBuffer(this.buffer.duplicate().order(byteOrder));
    }

    public void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffsetBooleans, int lengthBooleans) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthBooleans; ++i) {
            this.buffer.put(offset + i, (byte)(srcArray[i + srcOffsetBooleans] ? 1 : 0));
        }
    }

    public void putByteArray(long offsetBytes, byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthBytes; ++i) {
            this.buffer.put(offset + i, srcArray[srcOffsetBytes + i]);
        }
    }

    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthChars; ++i) {
            this.buffer.putChar(offset + i * 2, srcArray[srcOffsetChars + i]);
        }
    }

    public long putCharsToUtf8(long offsetBytes, CharSequence src) {
        byte[] bytes = StringUtils.toUtf8((String)src.toString());
        this.putByteArray(offsetBytes, bytes, 0, bytes.length);
        return bytes.length;
    }

    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthDoubles; ++i) {
            this.buffer.putDouble(offset + i * 8, srcArray[srcOffsetDoubles + i]);
        }
    }

    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthFloats; ++i) {
            this.buffer.putFloat(offset + i * 4, srcArray[srcOffsetFloats + i]);
        }
    }

    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthInts; ++i) {
            this.buffer.putInt(offset + i * 4, srcArray[srcOffsetInts + i]);
        }
    }

    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthLongs; ++i) {
            this.buffer.putLong(offset + i * 8, srcArray[srcOffsetLongs + i]);
        }
    }

    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        int offset = Ints.checkedCast((long)offsetBytes);
        for (int i = 0; i < lengthShorts; ++i) {
            this.buffer.putShort(offset + i * 2, srcArray[srcOffsetShorts + i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndAddLong(long offsetBytes, long delta) {
        long currentValue;
        int offset = Ints.checkedCast((long)offsetBytes);
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            currentValue = this.buffer.getLong(offset);
            this.buffer.putLong(offset, currentValue + delta);
        }
        return currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        int offset = Ints.checkedCast((long)offsetBytes);
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            long actual = this.buffer.getLong(offset);
            if (expect == actual) {
                this.buffer.putLong(offset, update);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndSetLong(long offsetBytes, long newValue) {
        int offset = Ints.checkedCast((long)offsetBytes);
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            long l = this.buffer.getLong(offset);
            this.buffer.putLong(offset, newValue);
            return l;
        }
    }

    public Object getArray() {
        return null;
    }

    public void clear() {
        this.fill((byte)0);
    }

    public void clear(long offsetBytes, long lengthBytes) {
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    public void clearBits(long offsetBytes, byte bitMask) {
        int offset = Ints.checkedCast((long)offsetBytes);
        int value = this.buffer.get(offset) & 0xFF;
        this.buffer.put(offset, (byte)(value &= ~bitMask));
    }

    public void fill(byte value) {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            this.buffer.put(i, value);
        }
    }

    public void fill(long offsetBytes, long lengthBytes, byte value) {
        int offset = Ints.checkedCast((long)offsetBytes);
        int length = Ints.checkedCast((long)lengthBytes);
        for (int i = 0; i < length; ++i) {
            this.buffer.put(offset + i, value);
        }
    }

    public void setBits(long offsetBytes, byte bitMask) {
        int offset = Ints.checkedCast((long)offsetBytes);
        this.buffer.put(offset, (byte)(this.buffer.get(offset) | bitMask));
    }
}

