/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class FrontCodedIndexedWriter
implements DictionaryWriter<byte[]> {
    private static final int MAX_LOG_BUFFER_SIZE = 26;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final int bucketSize;
    private final ByteOrder byteOrder;
    private final byte[][] bucketBuffer;
    private final ByteBuffer getOffsetBuffer;
    private final int div;
    @Nullable
    private byte[] prevObject = null;
    @Nullable
    private WriteOutBytes headerOut = null;
    @Nullable
    private WriteOutBytes valuesOut = null;
    private int numWritten = 0;
    private ByteBuffer scratch;
    private int logScratchSize = 10;
    private boolean isClosed = false;
    private boolean hasNulls = false;

    public FrontCodedIndexedWriter(SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder byteOrder, int bucketSize) {
        if (Integer.bitCount(bucketSize) != 1 || bucketSize < 1 || bucketSize > 128) {
            throw new IAE("bucketSize must be a power of two (from 1 up to 128) but was[%,d]", new Object[]{bucketSize});
        }
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.scratch = ByteBuffer.allocate(1 << this.logScratchSize).order(byteOrder);
        this.bucketSize = bucketSize;
        this.byteOrder = byteOrder;
        this.bucketBuffer = new byte[bucketSize][];
        this.getOffsetBuffer = ByteBuffer.allocate(4).order(byteOrder);
        this.div = Integer.numberOfTrailingZeros(bucketSize);
    }

    @Override
    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public void write(@Nullable byte[] value) throws IOException {
        if (this.prevObject != null && FrontCodedIndexedWriter.compareNullableUtf8UsingJavaStringOrdering(this.prevObject, value) >= 0) {
            throw new ISE("Values must be sorted and unique. Element [%s] with value [%s] is before or equivalent to [%s]", new Object[]{this.numWritten, value == null ? null : StringUtils.fromUtf8((byte[])value), StringUtils.fromUtf8((byte[])this.prevObject)});
        }
        if (value == null) {
            this.hasNulls = true;
            return;
        }
        if (this.numWritten > 0 && this.numWritten % this.bucketSize == 0) {
            int written;
            this.resetScratch();
            do {
                if ((written = FrontCodedIndexedWriter.writeBucket(this.scratch, this.bucketBuffer, this.bucketSize)) >= 0) continue;
                this.growScratch();
            } while (written < 0);
            this.scratch.flip();
            Channels.writeFully((WritableByteChannel)this.valuesOut, (ByteBuffer)this.scratch);
            this.resetScratch();
            this.scratch.putInt((int)this.valuesOut.size());
            this.scratch.flip();
            Channels.writeFully((WritableByteChannel)this.headerOut, (ByteBuffer)this.scratch);
        }
        this.bucketBuffer[this.numWritten % this.bucketSize] = value;
        ++this.numWritten;
        this.prevObject = value;
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (!this.isClosed) {
            this.flush();
        }
        int headerAndValues = Ints.checkedCast((long)(this.headerOut.size() + this.valuesOut.size()));
        return 3 + VByte.computeIntSize((int)this.numWritten) + VByte.computeIntSize((int)headerAndValues) + headerAndValues;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        if (!this.isClosed) {
            this.flush();
        }
        this.resetScratch();
        this.scratch.put((byte)0);
        this.scratch.put((byte)this.bucketSize);
        this.scratch.put(this.hasNulls ? (byte)1 : 0);
        VByte.writeInt((ByteBuffer)this.scratch, (int)this.numWritten);
        VByte.writeInt((ByteBuffer)this.scratch, (int)Ints.checkedCast((long)(this.headerOut.size() + this.valuesOut.size())));
        this.scratch.flip();
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)this.scratch);
        this.headerOut.writeTo(channel);
        this.valuesOut.writeTo(channel);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    @Nullable
    public byte[] get(int index) throws IOException {
        if (index == 0 && this.hasNulls) {
            return null;
        }
        int adjustedIndex = this.hasNulls ? index - 1 : index;
        int relativeIndex = adjustedIndex % this.bucketSize;
        if (adjustedIndex >= this.numWritten - this.bucketSize) {
            return this.bucketBuffer[relativeIndex];
        }
        int bucket = adjustedIndex >> this.div;
        long startOffset = bucket == 0 ? 0L : this.getBucketOffset(bucket - 1);
        long endOffset = this.getBucketOffset(bucket);
        int bucketSize = Ints.checkedCast((long)(endOffset - startOffset));
        if (bucketSize == 0) {
            return null;
        }
        ByteBuffer bucketBuffer = ByteBuffer.allocate(bucketSize).order(this.byteOrder);
        this.valuesOut.readFully(startOffset, bucketBuffer);
        bucketBuffer.clear();
        ByteBuffer valueBuffer = FrontCodedIndexed.getFromBucket(bucketBuffer, relativeIndex);
        byte[] valueBytes = new byte[valueBuffer.limit() - valueBuffer.position()];
        valueBuffer.get(valueBytes);
        return valueBytes;
    }

    private long getBucketOffset(int index) throws IOException {
        this.getOffsetBuffer.clear();
        this.headerOut.readFully((long)index * 4L, this.getOffsetBuffer);
        return this.getOffsetBuffer.getInt(0);
    }

    private void flush() throws IOException {
        int written;
        if (this.numWritten == 0) {
            return;
        }
        int remainder = this.numWritten % this.bucketSize;
        this.resetScratch();
        do {
            if ((written = FrontCodedIndexedWriter.writeBucket(this.scratch, this.bucketBuffer, remainder == 0 ? this.bucketSize : remainder)) >= 0) continue;
            this.growScratch();
        } while (written < 0);
        this.scratch.flip();
        Channels.writeFully((WritableByteChannel)this.valuesOut, (ByteBuffer)this.scratch);
        this.resetScratch();
        this.isClosed = true;
    }

    private void resetScratch() {
        this.scratch.position(0);
        this.scratch.limit(this.scratch.capacity());
    }

    private void growScratch() {
        if (this.logScratchSize >= 26) {
            throw new IllegalStateException("scratch buffer to big to write buckets");
        }
        this.scratch = ByteBuffer.allocate(1 << ++this.logScratchSize).order(this.byteOrder);
    }

    public static int writeBucket(ByteBuffer buffer, byte[][] values, int numValues) {
        int written;
        byte[] first = null;
        for (written = 0; written < numValues; ++written) {
            int cmp;
            int prefixLength;
            byte[] next = values[written];
            if (written == 0) {
                first = next;
                int rem = FrontCodedIndexedWriter.writeValue(buffer, first);
                if (rem >= 0) continue;
                return rem;
            }
            for (prefixLength = 0; prefixLength < first.length && (cmp = StringUtils.compareUtf8UsingJavaStringOrdering((byte)first[prefixLength], (byte)next[prefixLength])) == 0; ++prefixLength) {
            }
            byte[] suffix = new byte[next.length - prefixLength];
            System.arraycopy(next, prefixLength, suffix, 0, suffix.length);
            int rem = buffer.remaining() - VByte.computeIntSize((int)prefixLength);
            if (rem < 0) {
                return rem;
            }
            VByte.writeInt((ByteBuffer)buffer, (int)prefixLength);
            rem = FrontCodedIndexedWriter.writeValue(buffer, suffix);
            if (rem >= 0) continue;
            return rem;
        }
        return written;
    }

    public static int writeValue(ByteBuffer buffer, byte[] bytes) {
        int remaining = buffer.remaining() - VByte.computeIntSize((int)bytes.length) - bytes.length;
        if (remaining < 0) {
            return remaining;
        }
        int pos = buffer.position();
        VByte.writeInt((ByteBuffer)buffer, (int)bytes.length);
        buffer.put(bytes, 0, bytes.length);
        return buffer.position() - pos;
    }

    private static int compareNullableUtf8UsingJavaStringOrdering(@Nullable byte[] b1, @Nullable byte[] b2) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return StringUtils.compareUtf8UsingJavaStringOrdering((byte[])b1, (byte[])b2);
    }
}

