/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;

public final class FrontCodedIndexed
implements Indexed<ByteBuffer> {
    private final ByteBuffer buffer;
    private final int adjustedNumValues;
    private final int adjustIndex;
    private final int bucketSize;
    private final int numBuckets;
    private final int div;
    private final int rem;
    private final int offsetsPosition;
    private final int bucketsPosition;
    private final boolean hasNull;
    private final int lastBucketNumValues;

    public static Supplier<FrontCodedIndexed> read(ByteBuffer buffer, ByteOrder ordering) {
        ByteBuffer orderedBuffer = buffer.asReadOnlyBuffer().order(ordering);
        byte version = orderedBuffer.get();
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)("only V0 exists, encountered " + version));
        int bucketSize = Byte.toUnsignedInt(orderedBuffer.get());
        boolean hasNull = 1 == orderedBuffer.get();
        int numValues = VByte.readInt((ByteBuffer)orderedBuffer);
        int size = VByte.readInt((ByteBuffer)orderedBuffer);
        int offsetsPosition = orderedBuffer.position();
        buffer.position(offsetsPosition + size);
        return () -> new FrontCodedIndexed(buffer, ordering, bucketSize, numValues, hasNull, offsetsPosition);
    }

    private FrontCodedIndexed(ByteBuffer buffer, ByteOrder order, int bucketSize, int numValues, boolean hasNull, int offsetsPosition) {
        if (Integer.bitCount(bucketSize) != 1) {
            throw new ISE("bucketSize must be a power of two but was[%,d]", new Object[]{bucketSize});
        }
        this.buffer = buffer.asReadOnlyBuffer().order(order);
        this.bucketSize = bucketSize;
        this.hasNull = hasNull;
        this.numBuckets = (int)Math.ceil((double)numValues / (double)bucketSize);
        this.adjustIndex = hasNull ? 1 : 0;
        this.adjustedNumValues = numValues + this.adjustIndex;
        this.div = Integer.numberOfTrailingZeros(bucketSize);
        this.rem = bucketSize - 1;
        this.lastBucketNumValues = (numValues & this.rem) == 0 ? bucketSize : numValues & this.rem;
        this.offsetsPosition = offsetsPosition;
        this.bucketsPosition = offsetsPosition + (this.numBuckets - 1) * 4;
    }

    @Override
    public int size() {
        return this.adjustedNumValues;
    }

    @Override
    @Nullable
    public ByteBuffer get(int index) {
        if (this.hasNull && index == 0) {
            return null;
        }
        Indexed.checkIndex(index, this.adjustedNumValues);
        int adjustedIndex = index - this.adjustIndex;
        int bucket = adjustedIndex >> this.div;
        int bucketIndex = adjustedIndex & this.rem;
        int offset = this.getBucketOffset(bucket);
        this.buffer.position(offset);
        return FrontCodedIndexed.getFromBucket(this.buffer, bucketIndex);
    }

    @Override
    public int indexOf(@Nullable ByteBuffer value) {
        int sharedPrefix;
        int comparison;
        int firstOffset;
        int firstLength;
        int offset;
        if (value == null) {
            return this.hasNull ? 0 : -1;
        }
        int minBucketIndex = 0;
        int maxBucketIndex = this.numBuckets - 1;
        while (minBucketIndex < maxBucketIndex) {
            int currentBucket = minBucketIndex + maxBucketIndex >>> 1;
            int currBucketFirstValueIndex = currentBucket * this.bucketSize;
            offset = this.getBucketOffset(currentBucket);
            this.buffer.position(offset);
            firstLength = VByte.readInt((ByteBuffer)this.buffer);
            firstOffset = this.buffer.position();
            comparison = FrontCodedIndexed.compareBucketFirstValue(this.buffer, firstLength, value);
            sharedPrefix = this.buffer.position() - firstOffset;
            if (comparison == 0) {
                if (firstLength == value.remaining()) {
                    return currBucketFirstValueIndex + this.adjustIndex;
                }
                comparison = Integer.compare(firstLength, value.remaining());
            }
            int nextOffset = this.getBucketOffset(currentBucket + 1);
            this.buffer.position(nextOffset);
            int nextLength = VByte.readInt((ByteBuffer)this.buffer);
            int comparisonNext = FrontCodedIndexed.compareBucketFirstValue(this.buffer, nextLength, value);
            if (comparisonNext == 0) {
                if (nextLength == value.remaining()) {
                    return currBucketFirstValueIndex + this.adjustIndex + this.bucketSize;
                }
                comparisonNext = Integer.compare(nextLength, value.remaining());
            }
            if (comparison < 0 && comparisonNext > 0) {
                this.buffer.position(firstOffset + firstLength);
                return this.findValueInBucket(value, currBucketFirstValueIndex, this.bucketSize, sharedPrefix);
            }
            if (comparison < 0) {
                minBucketIndex = currentBucket + 1;
                continue;
            }
            maxBucketIndex = currentBucket - 1;
        }
        int bucketIndexBase = minBucketIndex * this.bucketSize;
        int numValuesInBucket = minBucketIndex == this.numBuckets - 1 ? this.lastBucketNumValues : this.bucketSize;
        offset = this.getBucketOffset(minBucketIndex);
        this.buffer.position(offset);
        firstLength = VByte.readInt((ByteBuffer)this.buffer);
        firstOffset = this.buffer.position();
        comparison = FrontCodedIndexed.compareBucketFirstValue(this.buffer, firstLength, value);
        sharedPrefix = this.buffer.position() - firstOffset;
        if (comparison == 0) {
            if (firstLength == value.remaining()) {
                return bucketIndexBase + this.adjustIndex;
            }
            comparison = Integer.compare(firstLength, value.remaining());
        }
        if (comparison > 0) {
            return -(bucketIndexBase + this.adjustIndex) - 1;
        }
        this.buffer.position(firstOffset + firstLength);
        return this.findValueInBucket(value, bucketIndexBase, numValuesInBucket, sharedPrefix);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        if (this.hasNull && this.adjustedNumValues == 1) {
            return Collections.singletonList(null).iterator();
        }
        final ByteBuffer copy = this.buffer.asReadOnlyBuffer().order(this.buffer.order());
        copy.position(this.bucketsPosition);
        final ByteBuffer[] firstBucket = FrontCodedIndexed.readBucket(copy, this.numBuckets > 1 ? this.bucketSize : this.lastBucketNumValues);
        return new Iterator<ByteBuffer>(){
            private int currIndex = 0;
            private int currentBucketIndex = 0;
            private ByteBuffer[] currentBucket = firstBucket;

            @Override
            public boolean hasNext() {
                return this.currIndex < FrontCodedIndexed.this.adjustedNumValues;
            }

            @Override
            public ByteBuffer next() {
                int offset;
                if (FrontCodedIndexed.this.hasNull && this.currIndex == 0) {
                    ++this.currIndex;
                    return null;
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int adjustedCurrIndex = FrontCodedIndexed.this.hasNull ? this.currIndex - 1 : this.currIndex;
                int bucketNum = adjustedCurrIndex >> FrontCodedIndexed.this.div;
                if (bucketNum != this.currentBucketIndex) {
                    offset = copy.getInt(FrontCodedIndexed.this.offsetsPosition + (bucketNum - 1) * 4);
                    copy.position(FrontCodedIndexed.this.bucketsPosition + offset);
                    this.currentBucket = FrontCodedIndexed.readBucket(copy, bucketNum < FrontCodedIndexed.this.numBuckets - 1 ? FrontCodedIndexed.this.bucketSize : FrontCodedIndexed.this.lastBucketNumValues);
                    this.currentBucketIndex = bucketNum;
                }
                offset = adjustedCurrIndex & FrontCodedIndexed.this.rem;
                ++this.currIndex;
                return this.currentBucket[offset];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("buffer", this.buffer);
        inspector.visit("hasNulls", this.hasNull);
        inspector.visit("bucketSize", this.bucketSize);
    }

    private int getBucketOffset(int bucket) {
        return this.bucketsPosition + (bucket > 0 ? this.buffer.getInt(this.offsetsPosition + (bucket - 1) * 4) : 0);
    }

    private static int compareBucketFirstValue(ByteBuffer bucketBuffer, int length, ByteBuffer value) {
        int startOffset = bucketBuffer.position();
        int commonLength = Math.min(length, value.remaining());
        int comparison = 0;
        for (int sharedPrefix = 0; sharedPrefix < commonLength; ++sharedPrefix) {
            comparison = StringUtils.compareUtf8UsingJavaStringOrdering((byte)bucketBuffer.get(), (byte)value.get(sharedPrefix));
            if (comparison == 0) continue;
            bucketBuffer.position(startOffset + sharedPrefix);
            break;
        }
        return comparison;
    }

    private int findValueInBucket(ByteBuffer value, int currBucketFirstValueIndex, int bucketSize, int sharedPrefix) {
        int relativePosition = 0;
        int insertionPoint = 1;
        while (++relativePosition < bucketSize) {
            int prefixLength = VByte.readInt((ByteBuffer)this.buffer);
            if (prefixLength > sharedPrefix) {
                int skip = VByte.readInt((ByteBuffer)this.buffer);
                this.buffer.position(this.buffer.position() + skip);
                ++insertionPoint;
                continue;
            }
            if (prefixLength < sharedPrefix) break;
            int fragmentLength = VByte.readInt((ByteBuffer)this.buffer);
            int common = Math.min(fragmentLength, value.remaining() - prefixLength);
            int fragmentComparison = 0;
            for (int i = 0; i < common && (fragmentComparison = StringUtils.compareUtf8UsingJavaStringOrdering((byte)this.buffer.get(this.buffer.position() + i), (byte)value.get(prefixLength + i))) == 0; ++i) {
            }
            if (fragmentComparison == 0) {
                fragmentComparison = Integer.compare(prefixLength + fragmentLength, value.remaining());
            }
            if (fragmentComparison == 0) {
                return currBucketFirstValueIndex + this.adjustIndex + relativePosition;
            }
            if (fragmentComparison >= 0) break;
            this.buffer.position(this.buffer.position() + fragmentLength);
            ++insertionPoint;
        }
        return -(currBucketFirstValueIndex + this.adjustIndex) + (-insertionPoint - 1);
    }

    static ByteBuffer getFromBucket(ByteBuffer buffer, int offset) {
        int prefixLength;
        if (offset == 0) {
            int length = VByte.readInt((ByteBuffer)buffer);
            ByteBuffer firstValue = buffer.asReadOnlyBuffer().order(buffer.order());
            firstValue.limit(firstValue.position() + length);
            return firstValue;
        }
        int firstLength = VByte.readInt((ByteBuffer)buffer);
        int prefixPosition = buffer.position();
        buffer.position(buffer.position() + firstLength);
        int pos = 0;
        while (true) {
            prefixLength = VByte.readInt((ByteBuffer)buffer);
            if (++pos >= offset) break;
            int skipLength = VByte.readInt((ByteBuffer)buffer);
            buffer.position(buffer.position() + skipLength);
        }
        int fragmentLength = VByte.readInt((ByteBuffer)buffer);
        int fragmentPosition = buffer.position();
        int valueLength = prefixLength + fragmentLength;
        ByteBuffer value = ByteBuffer.allocate(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            if (i < prefixLength) {
                value.put(buffer.get(prefixPosition + i));
                continue;
            }
            value.put(buffer.get(fragmentPosition + i - prefixLength));
        }
        value.flip();
        return value;
    }

    private static ByteBuffer[] readBucket(ByteBuffer bucket, int numValues) {
        int length = VByte.readInt((ByteBuffer)bucket);
        byte[] prefixBytes = new byte[length];
        bucket.get(prefixBytes, 0, length);
        ByteBuffer[] bucketBuffers = new ByteBuffer[numValues];
        bucketBuffers[0] = ByteBuffer.wrap(prefixBytes);
        int pos = 1;
        while (pos < numValues) {
            int prefixLength = VByte.readInt((ByteBuffer)bucket);
            int fragmentLength = VByte.readInt((ByteBuffer)bucket);
            byte[] fragment = new byte[fragmentLength];
            bucket.get(fragment, 0, fragmentLength);
            ByteBuffer value = ByteBuffer.allocate(prefixLength + fragmentLength);
            value.put(prefixBytes, 0, prefixLength);
            value.put(fragment);
            value.flip();
            bucketBuffers[pos++] = value;
        }
        return bucketBuffers;
    }
}

