/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.DictionaryWriter;

public class EncodedStringDictionaryWriter
implements DictionaryWriter<String> {
    public static final byte VERSION = 127;
    private final StringEncodingStrategy encodingStrategy;
    private final DictionaryWriter<byte[]> delegate;

    public EncodedStringDictionaryWriter(DictionaryWriter<byte[]> delegate, StringEncodingStrategy encodingStrategy) {
        this.delegate = delegate;
        this.encodingStrategy = encodingStrategy;
    }

    @Override
    public boolean isSorted() {
        return this.delegate.isSorted();
    }

    @Override
    public void open() throws IOException {
        this.delegate.open();
    }

    @Override
    public void write(@Nullable String objectToWrite) throws IOException {
        this.delegate.write(StringUtils.toUtf8Nullable((String)NullHandling.emptyToNullIfNeeded((String)objectToWrite)));
    }

    @Override
    @Nullable
    public String get(int dictId) throws IOException {
        byte[] bytes = this.delegate.get(dictId);
        if (bytes == null) {
            return null;
        }
        return StringUtils.fromUtf8((byte[])bytes);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return 2L + this.delegate.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{127}));
        channel.write(ByteBuffer.wrap(new byte[]{this.encodingStrategy.getId()}));
        this.delegate.writeTo(channel, smoosher);
    }
}

