/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.PeekingIterator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DictionaryMergingIterator;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.NestedDataColumnIndexer;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.StringDimensionMergerV9;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.nested.CompressedNestedDataComplexColumn;
import org.apache.druid.segment.nested.GlobalDictionarySortedCollector;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnMerger
implements DimensionMergerV9 {
    private static final Logger log = new Logger(NestedDataColumnMerger.class);
    public static final Comparator<Pair<Integer, PeekingIterator<Long>>> LONG_MERGING_COMPARATOR = DictionaryMergingIterator.makePeekingComparator();
    public static final Comparator<Pair<Integer, PeekingIterator<Double>>> DOUBLE_MERGING_COMPARATOR = DictionaryMergingIterator.makePeekingComparator();
    private final String name;
    private final Closer closer;
    private NestedDataColumnSerializer serializer;

    public NestedDataColumnMerger(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ProgressIndicator progressIndicator, Closer closer) {
        this.name = name;
        this.serializer = new NestedDataColumnSerializer(name, indexSpec, segmentWriteOutMedium, progressIndicator, closer);
        this.closer = closer;
    }

    @Override
    public void writeMergedValueDictionary(List<IndexableAdapter> adapters) throws IOException {
        long dimStartTime = System.currentTimeMillis();
        int numMergeIndex = 0;
        GlobalDictionarySortedCollector sortedLookup = null;
        Indexed[] sortedLookups = new Indexed[adapters.size()];
        Indexed[] sortedLongLookups = new Indexed[adapters.size()];
        Indexed[] sortedDoubleLookups = new Indexed[adapters.size()];
        TreeMap<String, NestedLiteralTypeInfo.MutableTypeSet> mergedFields = new TreeMap<String, NestedLiteralTypeInfo.MutableTypeSet>();
        for (int i = 0; i < adapters.size(); ++i) {
            GlobalDictionarySortedCollector dimValues;
            IndexableAdapter adapter = adapters.get(i);
            if (adapter instanceof IncrementalIndexAdapter) {
                dimValues = this.getSortedIndexFromIncrementalAdapter((IncrementalIndexAdapter)adapter, mergedFields);
            } else if (adapter instanceof QueryableIndexIndexableAdapter) {
                dimValues = this.getSortedIndexesFromQueryableAdapter((QueryableIndexIndexableAdapter)adapter, mergedFields);
            } else {
                throw new ISE("Unable to merge columns of unsupported adapter %s", new Object[]{adapter.getClass()});
            }
            boolean allNulls = this.allNull(dimValues.getSortedStrings()) && this.allNull(dimValues.getSortedLongs()) && this.allNull(dimValues.getSortedDoubles());
            sortedLookup = dimValues;
            if (allNulls) continue;
            sortedLookups[i] = dimValues.getSortedStrings();
            sortedLongLookups[i] = dimValues.getSortedLongs();
            sortedDoubleLookups[i] = dimValues.getSortedDoubles();
            ++numMergeIndex;
        }
        this.serializer.open();
        this.serializer.serializeFields(mergedFields);
        int cardinality = 0;
        if (numMergeIndex > 1) {
            DictionaryMergingIterator dictionaryMergeIterator = new DictionaryMergingIterator(sortedLookups, StringDimensionMergerV9.DICTIONARY_MERGING_COMPARATOR, true);
            DictionaryMergingIterator longDictionaryMergeIterator = new DictionaryMergingIterator(sortedLongLookups, LONG_MERGING_COMPARATOR, true);
            DictionaryMergingIterator doubleDictionaryMergeIterator = new DictionaryMergingIterator(sortedDoubleLookups, DOUBLE_MERGING_COMPARATOR, true);
            this.serializer.serializeStringDictionary(() -> dictionaryMergeIterator);
            this.serializer.serializeLongDictionary(() -> longDictionaryMergeIterator);
            this.serializer.serializeDoubleDictionary(() -> doubleDictionaryMergeIterator);
            cardinality = dictionaryMergeIterator.getCardinality();
        } else if (numMergeIndex == 1) {
            this.serializer.serializeStringDictionary(sortedLookup.getSortedStrings());
            this.serializer.serializeLongDictionary(sortedLookup.getSortedLongs());
            this.serializer.serializeDoubleDictionary(sortedLookup.getSortedDoubles());
            cardinality = sortedLookup.size();
        }
        log.debug("Completed dim[%s] conversions with cardinality[%,d] in %,d millis.", new Object[]{this.name, cardinality, System.currentTimeMillis() - dimStartTime});
    }

    @Nullable
    private GlobalDictionarySortedCollector getSortedIndexFromIncrementalAdapter(IncrementalIndexAdapter adapter, SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> mergedFields) {
        IncrementalIndex index = adapter.getIncrementalIndex();
        IncrementalIndex.DimensionDesc dim = index.getDimension(this.name);
        if (dim == null || !(dim.getIndexer() instanceof NestedDataColumnIndexer)) {
            return null;
        }
        NestedDataColumnIndexer indexer = (NestedDataColumnIndexer)dim.getIndexer();
        indexer.mergeFields(mergedFields);
        return indexer.getSortedCollector();
    }

    @Nullable
    private GlobalDictionarySortedCollector getSortedIndexesFromQueryableAdapter(QueryableIndexIndexableAdapter adapter, SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> mergedFields) {
        ColumnHolder columnHolder = adapter.getQueryableIndex().getColumnHolder(this.name);
        if (columnHolder == null) {
            return null;
        }
        BaseColumn col = columnHolder.getColumn();
        this.closer.register((Closeable)col);
        if (col instanceof CompressedNestedDataComplexColumn) {
            return this.getSortedIndexFromV1QueryableAdapter(mergedFields, col);
        }
        return null;
    }

    private GlobalDictionarySortedCollector getSortedIndexFromV1QueryableAdapter(SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> mergedFields, BaseColumn col) {
        CompressedNestedDataComplexColumn column = (CompressedNestedDataComplexColumn)col;
        this.closer.register((Closeable)column);
        for (int i = 0; i < column.getFields().size(); ++i) {
            String fieldPath = column.getFields().get(i);
            NestedLiteralTypeInfo.TypeSet types = column.getFieldInfo().getTypes(i);
            mergedFields.compute(fieldPath, (k, v) -> {
                if (v == null) {
                    return new NestedLiteralTypeInfo.MutableTypeSet(types.getByteValue());
                }
                return v.merge(types.getByteValue());
            });
        }
        return new GlobalDictionarySortedCollector(new StringEncodingStrategies.Utf8ToStringIndexed((Indexed<ByteBuffer>)column.getStringDictionary()), column.getLongDictionary(), column.getDoubleDictionary());
    }

    @Override
    public ColumnValueSelector convertSortedSegmentRowValuesToMergedRowValues(int segmentIndex, ColumnValueSelector source) {
        return source;
    }

    @Override
    public void processMergedRow(ColumnValueSelector selector) throws IOException {
        this.serializer.serialize(selector);
    }

    @Override
    public void writeIndexes(@Nullable List<IntBuffer> segmentRowNumConversions) {
    }

    @Override
    public boolean hasOnlyNulls() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() {
        return new ColumnDescriptor.Builder().setValueType(ValueType.COMPLEX).setHasMultipleValues(false).addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName("json").withDelegate(this.serializer).build()).build();
    }

    private <T> boolean allNull(Indexed<T> dimValues) {
        int size = dimValues.size();
        for (int i = 0; i < size; ++i) {
            if (dimValues.get(i) == null) continue;
            return false;
        }
        return true;
    }
}

