/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.loading.SegmentizerFactory;

public class IndexSpec {
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final CompressionStrategy dimensionCompression;
    private final StringEncodingStrategy stringDictionaryEncoding;
    private final CompressionStrategy metricCompression;
    private final CompressionFactory.LongEncodingStrategy longEncoding;
    @Nullable
    private final CompressionStrategy jsonCompression;
    @Nullable
    private final SegmentizerFactory segmentLoader;

    public IndexSpec() {
        this(null, null, null, null, null, null, null);
    }

    @VisibleForTesting
    public IndexSpec(@Nullable BitmapSerdeFactory bitmapSerdeFactory, @Nullable CompressionStrategy dimensionCompression, @Nullable CompressionStrategy metricCompression, @Nullable CompressionFactory.LongEncodingStrategy longEncoding) {
        this(bitmapSerdeFactory, dimensionCompression, null, metricCompression, longEncoding, null, null);
    }

    @VisibleForTesting
    public IndexSpec(@Nullable BitmapSerdeFactory bitmapSerdeFactory, @Nullable CompressionStrategy dimensionCompression, @Nullable CompressionStrategy metricCompression, @Nullable CompressionFactory.LongEncodingStrategy longEncoding, @Nullable SegmentizerFactory segmentLoader) {
        this(bitmapSerdeFactory, dimensionCompression, null, metricCompression, longEncoding, null, segmentLoader);
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") @Nullable BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") @Nullable CompressionStrategy dimensionCompression, @JsonProperty(value="stringDictionaryEncoding") @Nullable StringEncodingStrategy stringDictionaryEncoding, @JsonProperty(value="metricCompression") @Nullable CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") @Nullable CompressionFactory.LongEncodingStrategy longEncoding, @JsonProperty(value="jsonCompression") @Nullable CompressionStrategy jsonCompression, @JsonProperty(value="segmentLoader") @Nullable SegmentizerFactory segmentLoader) {
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.DefaultBitmapSerdeFactory();
        this.dimensionCompression = dimensionCompression == null ? CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY : dimensionCompression;
        this.stringDictionaryEncoding = stringDictionaryEncoding == null ? StringEncodingStrategy.DEFAULT : stringDictionaryEncoding;
        this.metricCompression = metricCompression == null ? CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY : metricCompression;
        this.longEncoding = longEncoding == null ? CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY : longEncoding;
        this.jsonCompression = jsonCompression;
        this.segmentLoader = segmentLoader;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    public StringEncodingStrategy getStringDictionaryEncoding() {
        return this.stringDictionaryEncoding;
    }

    @JsonProperty
    public CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public SegmentizerFactory getSegmentLoader() {
        return this.segmentLoader;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CompressionStrategy getJsonCompression() {
        return this.jsonCompression;
    }

    public Map<String, Object> asMap(ObjectMapper objectMapper) {
        return (Map)objectMapper.convertValue((Object)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        return Objects.equals(this.bitmapSerdeFactory, indexSpec.bitmapSerdeFactory) && this.dimensionCompression == indexSpec.dimensionCompression && Objects.equals(this.stringDictionaryEncoding, indexSpec.stringDictionaryEncoding) && this.metricCompression == indexSpec.metricCompression && this.longEncoding == indexSpec.longEncoding && Objects.equals((Object)this.jsonCompression, (Object)indexSpec.jsonCompression) && Objects.equals(this.segmentLoader, indexSpec.segmentLoader);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bitmapSerdeFactory, this.dimensionCompression, this.stringDictionaryEncoding, this.metricCompression, this.longEncoding, this.jsonCompression, this.segmentLoader});
    }

    public String toString() {
        return "IndexSpec{bitmapSerdeFactory=" + this.bitmapSerdeFactory + ", dimensionCompression=" + (Object)((Object)this.dimensionCompression) + ", stringDictionaryEncoding=" + this.stringDictionaryEncoding + ", metricCompression=" + (Object)((Object)this.metricCompression) + ", longEncoding=" + (Object)((Object)this.longEncoding) + ", jsonCompression=" + (Object)((Object)this.jsonCompression) + ", segmentLoader=" + this.segmentLoader + '}';
    }
}

